/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class DocumentRetrievalExample
extends SDKSample {
    public byte[] pdfDocumentBytes;
    public byte[] originalPdfDocumentBytes;
    public byte[] zippedDocumentsBytes;

    public static void main(String ... args) {
        new DocumentRetrievalExample().run();
    }

    @Override
    public void execute() {
        String documentId = "myDocumentId";
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package with a document workflow created using the eSignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("Second Document").fromStream(this.documentInputStream1, DocumentType.PDF).withId(documentId).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.pdfDocumentBytes = this.eslClient.downloadDocument(this.packageId, documentId);
        this.originalPdfDocumentBytes = this.eslClient.downloadOriginalDocument(this.packageId, documentId);
        this.zippedDocumentsBytes = this.eslClient.downloadZippedDocuments(this.packageId);
    }
}

