/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateMidnight;

public class BasicPackageCreationExample
extends SDKSample {
    public final String group1 = "group1";
    public final String group2 = "group2";
    public static final String PACKAGE_DESC = "This is a package created using the eSignLive SDK";
    public static final Date PACKAGE_EXPIRY = DateMidnight.now().plusMonths(1).toDate();
    public static final String PACKAGE_EMAIL_MSG = "This message should be delivered to all signers";
    public static final String PACKAGE_TIMEZONE_ID = "Canada/Mountain";
    public static final String SIGNER1_CUSTOM_ID = "Client1";
    public static final String SIGNER1_FIRST_NAME = "John";
    public static final String SIGNER1_LAST_NAME = "Smith";
    public static final String SIGNER1_TITLE = "Managing Director";
    public static final String SIGNER1_COMPANY = "Acme Inc.";
    public static final Locale SIGNER1_LANGUAGE = Locale.SIMPLIFIED_CHINESE;
    public static final String SIGNER2_FIRST_NAME = "Patty";
    public static final String SIGNER2_LAST_NAME = "Galant";
    public static final String DOCUMENT1_NAME = "First Document";
    public static final String DOCUMENT2_NAME = "Second Document";
    public static final Integer SIGNATURE_FONT_SIZE = 10;
    public static final Integer AUTO_FIELD_FONT_SIZE = 9;

    public static void main(String ... args) {
        new BasicPackageCreationExample().run();
    }

    @Override
    public void execute() {
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document_with_text_tag_and_form_field.pdf");
        this.email2 = "CapitalLetters@email.com";
        DocumentPackageSettings packageSettings = DocumentPackageSettingsBuilder.newDocumentPackageSettings().withoutDefaultTimeBasedExpiry().build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withTimezoneId(PACKAGE_TIMEZONE_ID).describedAs(PACKAGE_DESC).withSettings(packageSettings).expiresAt(PACKAGE_EXPIRY).withEmailMessage(PACKAGE_EMAIL_MSG).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId(SIGNER1_CUSTOM_ID).withFirstName(SIGNER1_FIRST_NAME).withLastName(SIGNER1_LAST_NAME).withLanguage(SIGNER1_LANGUAGE).withTitle(SIGNER1_TITLE).withCompany(SIGNER1_COMPANY)).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName(SIGNER2_FIRST_NAME).withLastName(SIGNER2_LAST_NAME)).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT1_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).withFontSize(SIGNATURE_FONT_SIZE).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(50.0, 50.0).withValue("X")).withField(FieldBuilder.signerName().onPage(0).atPosition(150.0, 50.0).withFontSize(AUTO_FIELD_FONT_SIZE)).atPosition(100.0, 100.0))).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT2_NAME).fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).withField(FieldBuilder.radioButton("group1").withName("firstField").onPage(0).atPosition(400.0, 300.0).withSize(20.0, 20.0).withValue(false)).withField(FieldBuilder.radioButton("group1").withName("secondField").onPage(0).atPosition(400.0, 400.0).withSize(20.0, 20.0).withValue(true)).withField(FieldBuilder.radioButton("group2").withName("thirdField").onPage(0).atPosition(400.0, 500.0).withSize(20.0, 20.0).withValue(true)).withField(FieldBuilder.radioButton("group2").withName("fourthField").onPage(0).atPosition(400.0, 600.0).withSize(20.0, 20.0).withValue(false)).atPosition(100.0, 200.0))).build();
        this.packageId = this.eslClient.createPackageOneStep(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
    }
}

