/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AttachmentFile;
import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.AttachmentRequirementBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.builder.internal.StreamDocumentSource;
import com.silanis.esl.sdk.examples.SDKSample;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.io.Files;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class AttachmentFileExample
extends SDKSample {
    private InputStream attachmentInputStream = this.getClass().getClassLoader().getResourceAsStream("document-for-anchor-extraction.pdf");
    private Signer signer;
    public static final String NAME = "Driver's license";
    public static final String DESCRIPTION = "Please upload a scanned copy of your driver's license.";
    public static final String SIGNER1_ID = "signerId";
    private List<AttachmentRequirement> signerAttachments;
    private AttachmentRequirement signerAtt;
    public static final String ATTACHMENT_FILE_NAME = "The attachment for signer.pdf";
    public List<AttachmentFile> filesAfterUpload;
    public List<AttachmentFile> filesAfterDelete;
    public File downloadedAttachmentFile;
    public long signerAttachmentFileSize;

    public static void main(String ... args) {
        new AttachmentFileExample().run();
    }

    @Override
    protected void execute() {
        this.signer = SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withCustomId(SIGNER1_ID).withAttachmentRequirement(AttachmentRequirementBuilder.newAttachmentRequirementWithName(NAME).withDescription(DESCRIPTION).isRequiredAttachment().build()).build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withSigner(this.signer).withDocument(DocumentBuilder.newDocumentWithName("test document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).build()).build()).build();
        this.packageId = this.eslClient.createAndSendPackage(superDuperPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.signerAttachments = this.retrievedPackage.getSigner(this.email1).getAttachmentRequirements();
        this.signerAtt = this.signerAttachments.get(0);
        byte[] attachmentForSignerFileContent = new StreamDocumentSource(this.attachmentInputStream).content();
        this.eslClient.uploadAttachment(this.packageId, this.signerAtt.getId(), ATTACHMENT_FILE_NAME, attachmentForSignerFileContent, SIGNER1_ID);
        this.signerAttachmentFileSize = attachmentForSignerFileContent.length;
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.signerAttachments = this.retrievedPackage.getSigner(this.email1).getAttachmentRequirements();
        this.signerAtt = this.signerAttachments.get(0);
        this.filesAfterUpload = this.signerAtt.getFiles();
        AttachmentFile attachmentFile = this.filesAfterUpload.get(0);
        DownloadedFile downloadedAttachment = this.eslClient.getAttachmentRequirementService().downloadAttachmentFile(this.packageId, this.signerAtt.getId(), attachmentFile.getId());
        Files.saveTo(downloadedAttachment.getContents(), downloadedAttachment.getFilename());
        this.downloadedAttachmentFile = new File(downloadedAttachment.getFilename());
        this.eslClient.deleteAttachmentFile(this.packageId, this.signerAtt.getId(), attachmentFile.getId(), SIGNER1_ID);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.signerAttachments = this.retrievedPackage.getSigner(this.email1).getAttachmentRequirements();
        this.signerAtt = this.signerAttachments.get(0);
        this.filesAfterDelete = this.signerAtt.getFiles();
    }
}

