/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.SubAccount;

public class SubAccountBuilder {
    private String name;
    private String timezoneId;
    private String language;
    private String parentAccountId;

    private SubAccountBuilder() {
    }

    public static SubAccountBuilder newSubAccount() {
        return new SubAccountBuilder();
    }

    public static SubAccountBuilder newSubAccount(String name) {
        return new SubAccountBuilder().withName(name);
    }

    public static SubAccountBuilder newSubAccount(SubAccount subAccount) {
        SubAccountBuilder builder = SubAccountBuilder.newSubAccount(subAccount.getName());
        return builder.withParentAccountId(subAccount.getParentAccountId()).withLanguage(subAccount.getLanguage()).withTimezoneId(subAccount.getTimezoneId());
    }

    public SubAccountBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SubAccountBuilder withParentAccountId(String parentAccountId) {
        this.parentAccountId = parentAccountId;
        return this;
    }

    public SubAccountBuilder withLanguage(String language) {
        this.language = language;
        return this;
    }

    public SubAccountBuilder withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public SubAccount build() {
        SubAccount subAccount = new SubAccount();
        subAccount.setName(this.name);
        subAccount.setLanguage(this.language);
        subAccount.setTimezoneId(this.timezoneId);
        subAccount.setParentAccountId(this.parentAccountId);
        return subAccount;
    }
}

