/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CreditCard;
import com.silanis.esl.sdk.License;
import com.silanis.esl.sdk.Plan;
import com.silanis.esl.sdk.Price;
import com.silanis.esl.sdk.Transaction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LicenseBuilder {
    private Date created;
    private Date paidUntil;
    private Plan plan;
    private String status;
    private List<Transaction> transactions = new ArrayList<Transaction>();

    private LicenseBuilder() {
    }

    public static LicenseBuilder newLicense() {
        return new LicenseBuilder();
    }

    public LicenseBuilder withCreated(Date created) {
        this.created = created;
        return this;
    }

    public LicenseBuilder withPaidUntil(Date paidUntil) {
        this.paidUntil = paidUntil;
        return this;
    }

    public LicenseBuilder withStatus(String status) {
        this.status = status;
        return this;
    }

    public LicenseBuilder withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public LicenseBuilder withTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public LicenseBuilder withTransaction(Transaction transaction) {
        this.transactions.add(transaction);
        return this;
    }

    public LicenseBuilder withTransaction(Date created, CreditCard creditCard, Price price) {
        Transaction transaction = new Transaction();
        transaction.setCreated(created);
        transaction.setCreditCard(creditCard);
        transaction.setPrice(price);
        this.transactions.add(transaction);
        return this;
    }

    public License build() {
        License license = new License();
        license.setCreated(this.created);
        license.setPaidUntil(this.paidUntil);
        license.setStatus(this.status);
        license.setPlan(this.plan);
        license.setTransactions(this.transactions);
        return license;
    }
}

