/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.apitoken;

import com.silanis.esl.sdk.internal.Asserts;

public class ApiTokenConfig {
    public static final String ACCESS_TOKEN_URL = "/apitoken/clientApp/accessToken";
    private String baseUrl;
    private String clientAppId;
    private String clientAppSecret;
    private TokenType tokenType;
    private String senderEmail;

    private ApiTokenConfig(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.clientAppId = builder.clientAppId;
        this.clientAppSecret = builder.clientAppSecret;
        this.tokenType = builder.tokenType;
        this.senderEmail = builder.senderEmail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientAppId() {
        return this.clientAppId;
    }

    public String getClientAppSecret() {
        return this.clientAppSecret;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getSenderEmail() {
        return this.senderEmail;
    }

    public String toString() {
        return "ApiTokenConfig{baseUrl='" + this.baseUrl + '\'' + ", clientAppId='" + this.clientAppId + '\'' + ", clientAppSecret='" + this.clientAppSecret + '\'' + ", tokenType=" + (Object)((Object)this.tokenType) + ", senderEmail='" + this.senderEmail + '\'' + '}';
    }

    public static final class Builder {
        private String baseUrl;
        private String clientAppId;
        private String clientAppSecret;
        private TokenType tokenType;
        private String senderEmail;

        private Builder() {
        }

        public Builder baseUrl(String val) {
            this.baseUrl = val;
            if (this.baseUrl != null && this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
            }
            return this;
        }

        public Builder clientAppId(String val) {
            this.clientAppId = val;
            return this;
        }

        public Builder clientAppSecret(String val) {
            this.clientAppSecret = val;
            return this;
        }

        public Builder tokenType(TokenType val) {
            this.tokenType = val;
            return this;
        }

        public Builder senderEmail(String val) {
            this.senderEmail = val;
            return this;
        }

        public ApiTokenConfig build() {
            Asserts.notNull(this.baseUrl, "baseUrl");
            Asserts.notNull(this.clientAppId, "clientAppId");
            Asserts.notNull(this.clientAppSecret, "clientAppSecret");
            Asserts.notNull((Object)this.tokenType, "tokenType");
            if (this.tokenType == TokenType.SENDER) {
                Asserts.notNull(this.senderEmail, "senderEmail");
            }
            return new ApiTokenConfig(this);
        }
    }

    public static enum TokenType {
        OWNER,
        SENDER;

    }
}

