/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.sdk.PageRequest;
import java.util.Iterator;
import java.util.List;

public class Page<T>
implements Iterable<T> {
    private final PageRequest request;
    private int totalElements;
    private List<T> results;

    public Page(List<T> results, int totalElements, PageRequest request) {
        this.request = request;
        this.totalElements = totalElements;
        this.results = results;
    }

    public int getSize() {
        return this.request.getPageSize();
    }

    public int getNumberOfElements() {
        return this.results.size();
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public boolean hasNextPage() {
        return this.request.getFrom() + this.request.getPageSize() <= this.totalElements;
    }

    public PageRequest getNextRequest() {
        return this.hasNextPage() ? this.request.next() : null;
    }

    public List<T> getResults() {
        return this.results;
    }

    @Override
    public Iterator<T> iterator() {
        return this.results.iterator();
    }
}

