/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentVisibilityConfiguration;
import com.silanis.esl.sdk.Signer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DocumentVisibility {
    private List<DocumentVisibilityConfiguration> configurations = new ArrayList<DocumentVisibilityConfiguration>();

    public List<DocumentVisibilityConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<DocumentVisibilityConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void addConfiguration(DocumentVisibilityConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public List<Document> getDocuments(DocumentPackage documentPackage, final String signerId) {
        return new ArrayList<Document>(Collections2.filter(documentPackage.getDocuments(), new Predicate<Document>(){

            @Override
            public boolean apply(Document input) {
                DocumentVisibilityConfiguration configuration = DocumentVisibility.this.getConfiguration(input.getId().getId());
                return configuration != null && configuration.getSignerIds().contains(signerId);
            }
        }));
    }

    public List<Signer> getSigners(DocumentPackage documentPackage, String documentId) {
        final DocumentVisibilityConfiguration configuration = this.getConfiguration(documentId);
        return new ArrayList<Signer>(Collections2.filter(documentPackage.getSigners(), new Predicate<Signer>(){

            @Override
            public boolean apply(Signer input) {
                return configuration.getSignerIds().contains(input.getId());
            }
        }));
    }

    public DocumentVisibilityConfiguration getConfiguration(String documentUid) {
        for (DocumentVisibilityConfiguration configuration : this.getConfigurations()) {
            if (!StringUtils.equals(documentUid, configuration.getDocumentUid())) continue;
            return configuration;
        }
        return null;
    }
}

