/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.silanis.esl.api.JsonDeserializationException;
import com.silanis.esl.api.util.DirtyFieldsFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JacksonUtil {
    private static final String CLASS = JacksonUtil.class.getName();
    protected static Logger log = Logger.getLogger(CLASS);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> T deserialize(String json, Class<T> cl) {
        try {
            return mapper.readValue(json, cl);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to deserialize json string: " + json, e);
            throw new JsonDeserializationException(cl, (Throwable)e);
        }
    }

    public static <T> List<T> deserializeList(String json, Class<T> cl) {
        List<Object> obj;
        try {
            obj = (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, cl));
        }
        catch (JsonMappingException me) {
            obj = new ArrayList<T>();
            obj.add(JacksonUtil.deserialize(json, cl));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to deserialize json list: " + json, e);
            throw new JsonDeserializationException(cl, (Throwable)e);
        }
        return obj;
    }

    public static <T> T deserialize(String json, TypeReference<T> typeReference) {
        try {
            return mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to deserialize generic object: " + json, e);
            throw new JsonDeserializationException(typeReference, (Throwable)e);
        }
    }

    public static String serializeDirty(Object json) {
        return JacksonUtil._serialize(json, true);
    }

    public static String serialize(Object json) {
        return JacksonUtil._serialize(json, false);
    }

    private static String _serialize(Object json, boolean filterDirtyFields) {
        String result = null;
        try {
            ObjectMapper mapperFilter = new ObjectMapper();
            DirtyFieldsFilter filter = new DirtyFieldsFilter(filterDirtyFields);
            SimpleFilterProvider fp = new SimpleFilterProvider().addFilter("DirtyFieldsFilter", filter).setDefaultFilter(filter).setFailOnUnknownId(false);
            result = mapperFilter.writer(fp).writeValueAsString(json);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to serialize json object: " + json, e);
            throw new RuntimeException("Invalid arguments.", e);
        }
        return result;
    }

    public static String merge(String base, String delta) throws IOException {
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        if (JacksonUtil.isEmpty(delta)) {
            return base;
        }
        if (JacksonUtil.isEmpty(base)) {
            return delta;
        }
        Map<String, Object> baseMap = mapper.readValue(base, typeRef);
        Map<String, Object> deltaMap = mapper.readValue(delta, typeRef);
        Map<String, Object> resultMap = JacksonUtil.merge(baseMap, deltaMap);
        return JacksonUtil.serialize(resultMap);
    }

    private static boolean isEmpty(String s2) {
        return s2 == null || s2.length() == 0;
    }

    public static Map<String, Object> merge(Map<String, Object> baseMap, Map<String, Object> deltaMap) {
        if (baseMap == null) {
            baseMap = new LinkedHashMap<String, Object>();
        }
        if (deltaMap == null) {
            deltaMap = new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(baseMap);
        for (String key : deltaMap.keySet()) {
            Object value = deltaMap.get(key);
            if (value == null) {
                resultMap.put(key, null);
                continue;
            }
            if (value instanceof Map) {
                if (baseMap.containsKey(key)) {
                    resultMap.put(key, JacksonUtil.merge((Map)baseMap.get(key), (Map)value));
                    continue;
                }
                resultMap.put(key, value);
                continue;
            }
            if (value instanceof List) {
                if (baseMap.containsKey(key)) {
                    List resultList = (List)resultMap.get(key);
                    resultList.addAll((List)value);
                    continue;
                }
                resultMap.put(key, value);
                continue;
            }
            resultMap.put(key, value);
        }
        return resultMap;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }
}

