/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerUDT {
    protected static final Logger log = LoggerFactory.getLogger(ResourceManagerUDT.class);
    protected static final int EOF = -1;

    protected static boolean isSameResource(URLConnection conONE, URLConnection conTWO) throws Exception {
        long timeONE = conONE.getLastModified();
        long sizeONE = conONE.getContentLength();
        long timeTWO = conTWO.getLastModified();
        long sizeTWO = conTWO.getContentLength();
        return sizeONE == sizeTWO && timeONE == timeTWO;
    }

    protected static URLConnection fileConnection(File file) throws Exception {
        URL url = file.toURI().toURL();
        URLConnection connection = url.openConnection();
        return connection;
    }

    protected static long timeStamp(URLConnection connIN) {
        return connIN.getLastModified();
    }

    protected static void extractResource(String sourcePath, String targetPath) throws Exception {
        URL sourceUrl = ResourceManagerUDT.class.getResource(sourcePath);
        if (sourceUrl == null) {
            log.warn("classpath resource not found: {}", (Object)sourcePath);
            throw new IllegalArgumentException("resource not found");
        }
        log.debug("sourceURL={} ", sourceUrl);
        URLConnection sourceConn = sourceUrl.openConnection();
        if (sourceConn == null) {
            log.warn("classpath resource connection not available: {}", (Object)sourcePath);
            throw new IllegalArgumentException("resource not found");
        }
        File targetFile = new File(targetPath).getAbsoluteFile();
        log.debug("targetFile={} ", targetFile);
        File targetFolder = targetFile.getParentFile().getAbsoluteFile();
        log.debug("targetFolder={} ", targetFolder);
        ResourceManagerUDT.ensureTargetFolder(targetFolder);
        URLConnection targetConn = ResourceManagerUDT.fileConnection(targetFile);
        if (ResourceManagerUDT.isSameResource(sourceConn, targetConn)) {
            log.debug("already extracted; sourcePath={} targetPath={}", (Object)sourcePath, (Object)targetPath);
            return;
        }
        log.debug("make new extraction destination for targetPath={}", (Object)targetPath);
        targetFile.delete();
        targetFile.createNewFile();
        long sourceTime = ResourceManagerUDT.timeStamp(sourceConn);
        BufferedInputStream sourceStream = new BufferedInputStream(sourceUrl.openStream());
        BufferedOutputStream targetStream = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] array = new byte[65536];
        int readCount = 0;
        while ((readCount = ((InputStream)sourceStream).read(array)) != -1) {
            ((OutputStream)targetStream).write(array, 0, readCount);
        }
        ((OutputStream)targetStream).flush();
        ((InputStream)sourceStream).close();
        ((OutputStream)targetStream).close();
        targetFile.setLastModified(sourceTime);
        log.debug("extracted OK; sourcePath={} targetPath={}", (Object)sourcePath, (Object)targetPath);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void ensureTargetFolder(File folder) throws Exception {
        if (folder.exists()) {
            if (folder.isDirectory()) {
                log.debug("found folder={}", folder);
                return;
            }
            log.error("not a directory; folder={}", folder);
            throw new IllegalArgumentException("extract destination exists, but as a file and not a folder");
        }
        boolean isSuccess = folder.mkdirs();
        if (isSuccess) {
            log.debug("mkdirs : folder={}", folder);
            return;
        }
        log.error("mkdirs failure; folder={}", folder);
        throw new IllegalStateException("failed to make extract destination folder");
    }

    protected static void ensureTargetFolder(String targetFolder) throws Exception {
        File folder = new File(targetFolder).getAbsoluteFile();
        ResourceManagerUDT.ensureTargetFolder(folder);
    }

    protected static void systemLoad(String targetPath) throws Exception {
        File loadFile = new File(targetPath);
        String loadPath = loadFile.getAbsolutePath();
        System.load(loadPath);
    }

    protected static void systemLoad(String sourcePath, String targetPath) throws Exception {
        ResourceManagerUDT.extractResource(sourcePath, targetPath);
        ResourceManagerUDT.systemLoad(targetPath);
    }
}

