/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StatusUDT {
    INIT(1),
    OPENED(2),
    LISTENING(3),
    CONNECTING(4),
    CONNECTED(5),
    BROKEN(6),
    CLOSING(7),
    CLOSED(8),
    NONEXIST(9),
    UNKNOWN(100);

    protected static final Logger log;
    private final int code;

    private StatusUDT(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static final StatusUDT from(int code) {
        switch (code) {
            case 1: {
                return INIT;
            }
            case 2: {
                return OPENED;
            }
            case 3: {
                return LISTENING;
            }
            case 4: {
                return CONNECTING;
            }
            case 5: {
                return CONNECTED;
            }
            case 6: {
                return BROKEN;
            }
            case 7: {
                return CLOSING;
            }
            case 8: {
                return CLOSED;
            }
            case 9: {
                return NONEXIST;
            }
        }
        log.error("unexpected code={}", code);
        return UNKNOWN;
    }

    static {
        log = LoggerFactory.getLogger(StatusUDT.class);
    }
}

