/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.ExceptionUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpollUDT {
    protected static final Logger log = LoggerFactory.getLogger(EpollUDT.class);
    protected final int id = SocketUDT.epollCreate0();
    protected volatile boolean isActive = true;
    private final SocketUDT socketUDT = new SocketUDT(TypeUDT.DATAGRAM);

    public EpollUDT() throws ExceptionUDT {
        SocketUDT.epollAdd0(this.id, this.socketUDT.id(), Opt.BOTH.code);
        log.debug("ep {} create", this.id());
    }

    public void destroy() throws ExceptionUDT {
        SocketUDT.epollRemove0(this.id(), this.socketUDT.id());
        this.socketUDT.close();
        this.isActive = false;
        SocketUDT.epollRelease0(this.id());
        log.debug("ep {} delete", this.id());
    }

    public int id() {
        return this.id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected void finalize() {
        try {
            this.destroy();
            super.finalize();
        }
        catch (Throwable e) {
            log.error("failed to destroy id=" + this.id(), e);
        }
    }

    public void add(SocketUDT socket, Opt option) throws ExceptionUDT {
        log.debug("ep {} add {} {}", new Object[]{this.id(), socket, option});
        SocketUDT.epollAdd0(this.id(), socket.id(), option.code);
    }

    public void remove(SocketUDT socket) throws ExceptionUDT {
        log.debug("ep {} rem {}", this.id(), (Object)socket);
        SocketUDT.epollRemove0(this.id(), socket.id());
    }

    public void update(SocketUDT socket, Opt option) throws ExceptionUDT {
        log.debug("ep {} mod {} {}", new Object[]{this.id(), socket, option});
        assert (option.isValidInterestRequest());
        SocketUDT.epollUpdate0(this.id(), socket.id(), option.code);
    }

    public Opt verify(SocketUDT socket) throws ExceptionUDT {
        int code = SocketUDT.epollVerify0(this.id(), socket.id());
        return Opt.from(code);
    }

    public static enum Opt {
        NONE(0),
        READ(1),
        WRITE(4),
        ERROR(8),
        BOTH(Opt.WRITE.code | Opt.READ.code),
        ERROR_READ(Opt.ERROR.code | Opt.READ.code),
        ERROR_WRITE(Opt.ERROR.code | Opt.WRITE.code),
        ALL(Opt.ERROR.code | Opt.WRITE.code | Opt.READ.code),
        UNKNOWN(-1);

        private static final Opt[] ENUM_VALS;
        public final int code;

        public static Opt from(int code) {
            for (Opt known : ENUM_VALS) {
                if (known.code != code) continue;
                return known;
            }
            return UNKNOWN;
        }

        private Opt(int code) {
            this.code = code;
        }

        public boolean hasError() {
            return (this.code & Opt.ERROR.code) != 0;
        }

        public boolean hasRead() {
            return (this.code & Opt.READ.code) != 0;
        }

        public boolean hasWrite() {
            return (this.code & Opt.WRITE.code) != 0;
        }

        public boolean isValidInterestRequest() {
            switch (this) {
                case NONE: 
                case READ: 
                case WRITE: 
                case ERROR: 
                case BOTH: 
                case ERROR_WRITE: 
                case ERROR_READ: 
                case ALL: {
                    return true;
                }
            }
            return false;
        }

        static {
            ENUM_VALS = Opt.values();
        }
    }
}

