/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.PartitionInformationTree;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.PartitionMethod;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.UniqueID;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

@ThreadSafe
public class ParseInfo
implements DataFormatDescription {
    private final ConnectionSapDB _connection;
    private final String _sql;
    private final FunctionCode _functionCode;
    private final boolean _isSelect;
    private final boolean _isProcedure;
    private final UniqueID _tableLocationCounter;
    @GuardedBy(value="itself")
    private final Map<Session, ParseID> _parseIDs = new WeakHashMap<Session, ParseID>();
    @GuardedBy(value="this")
    private List<AbstractConverter> _parameterConverters;
    @GuardedBy(value="this")
    private Map<String, AbstractConverter> _parameterConverterMap;
    @GuardedBy(value="this")
    private int _inputParameterCount;
    @GuardedBy(value="this")
    private List<DataType> _outputDataTypes;
    @GuardedBy(value="this")
    private boolean _hasInputLOB;
    @GuardedBy(value="this")
    private boolean _hasOutputLOB;
    @GuardedBy(value="this")
    private boolean _hasResultSetLOB;
    @GuardedBy(value="this")
    private List<AbstractConverter> _resultSetConverters;
    @GuardedBy(value="this")
    private List<SiteTypeVolumeID> _tableLocations;
    @GuardedBy(value="this")
    private PartitionInformationTree _partitionInformationTree;

    public ParseInfo(Tracer tracer, ConnectionSapDB connection, String sql, FunctionCode functionCode, UniqueID uniqueID) throws SQLException {
        this._connection = connection;
        this._sql = sql;
        this._functionCode = functionCode;
        switch (functionCode) {
            case Select: 
            case SelectForUpdate: {
                this._isSelect = true;
                this._isProcedure = false;
                break;
            }
            case DBProcedureCall: {
                this._isSelect = false;
                this._isProcedure = true;
                break;
            }
            case DBProcedureCallWithResultSet: {
                this._isSelect = true;
                this._isProcedure = true;
                break;
            }
            default: {
                this._isSelect = false;
                this._isProcedure = false;
            }
        }
        this._tableLocationCounter = new UniqueID(uniqueID.getNextID());
        this._parameterConverters = Collections.emptyList();
        this._parameterConverterMap = new TreeMap<String, AbstractConverter>(String.CASE_INSENSITIVE_ORDER);
        this._inputParameterCount = 0;
        this._outputDataTypes = new ArrayList<DataType>();
        this._hasInputLOB = false;
        this._hasOutputLOB = false;
        this._hasResultSetLOB = false;
        this._resultSetConverters = new ArrayList<AbstractConverter>();
        this._partitionInformationTree = new PartitionInformationTree(tracer);
    }

    @Override
    public synchronized int getOutputFieldCount() {
        return this._outputDataTypes.size();
    }

    @Override
    public synchronized DataType getOutputFieldDataType(int outputFieldPos) {
        return this._outputDataTypes.get(outputFieldPos - 1);
    }

    @Override
    public boolean isOutputFieldEncrypted(int outputFieldPos) {
        return false;
    }

    @Override
    public synchronized int getResultSetColumnCount() {
        return this._resultSetConverters.size();
    }

    @Override
    public synchronized AbstractConverter getResultSetConverter(int index) {
        return this._resultSetConverters.get(index - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return super.toString() + Arrays.toString(this._parseIDs.values().toArray());
        }
    }

    public String getSQL() {
        return this._sql;
    }

    public FunctionCode getFunctionCode() {
        return this._functionCode;
    }

    public boolean isSelect() {
        return this._isSelect;
    }

    public boolean isProcedure() {
        return this._isProcedure;
    }

    public UniqueID getTableLocationCounter() {
        return this._tableLocationCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Session, ParseID> getParseIDs() {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return new HashMap<Session, ParseID>(this._parseIDs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseID getParseID(Session session) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            return this._parseIDs.get(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParseID(Session session, ParseID parseID) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            this._parseIDs.put(session, parseID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParseID(Session session) {
        Map<Session, ParseID> map = this._parseIDs;
        synchronized (map) {
            this._parseIDs.remove(session);
        }
    }

    public synchronized List<AbstractConverter> getParameterConverters() {
        return this._parameterConverters;
    }

    public synchronized AbstractConverter getParameterConverter(int index) {
        return this._parameterConverters.get(index - 1);
    }

    public synchronized AbstractConverter getParameterConverter(String parameterName) {
        return this._parameterConverterMap.get(parameterName);
    }

    public synchronized int getParameterCount() {
        return this._parameterConverters.size();
    }

    public synchronized int getInputParameterCount() {
        return this._inputParameterCount;
    }

    public synchronized boolean hasInputLOB() {
        return this._hasInputLOB;
    }

    public synchronized boolean hasOutputLOB() {
        return this._hasOutputLOB;
    }

    public synchronized boolean hasResultSetLOB() {
        return this._hasResultSetLOB;
    }

    public synchronized void setHasResultSetLOB() {
        this._hasResultSetLOB = true;
    }

    public synchronized void setParameterInfo(List<AbstractConverter> parameterConverters, int inputParameterCount, List<DataType> outputDataTypes, boolean hasInputLOB, boolean hasOutputLOB) {
        this._parameterConverters = Collections.unmodifiableList(parameterConverters);
        this._partitionInformationTree.setParameterConverters(this._parameterConverters);
        this._inputParameterCount = inputParameterCount;
        this._outputDataTypes = outputDataTypes;
        this._hasInputLOB |= hasInputLOB;
        this._hasOutputLOB |= hasOutputLOB;
        this._parameterConverterMap.clear();
        for (AbstractConverter converter : parameterConverters) {
            String parameterName = converter.getColumnLabel();
            if (this._parameterConverterMap.containsKey(parameterName)) continue;
            this._parameterConverterMap.put(parameterName, converter);
        }
    }

    public synchronized List<AbstractConverter> getResultSetConverters() {
        return this._resultSetConverters;
    }

    public synchronized void setResultSetConverters(List<AbstractConverter> resultSetConverters) {
        this._resultSetConverters = resultSetConverters;
    }

    public synchronized List<SiteTypeVolumeID> getTableLocations() {
        return this._tableLocations;
    }

    public synchronized void setTableLocations(List<SiteTypeVolumeID> tableLocations) {
        this._tableLocations = Collections.unmodifiableList(tableLocations);
    }

    public synchronized boolean isHashPartitioned() {
        return this._partitionInformationTree.isHashPartitioned();
    }

    public synchronized SiteTypeVolumeID getFirstPartitionVolumeID() {
        try {
            return this._partitionInformationTree.getFirstPartitionVolumeID();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public synchronized boolean isRangePartitioned() {
        return this._partitionInformationTree.isRangePartitioned();
    }

    public synchronized void addPartitionInformationNode(HPartInfo partInfo, Map<Byte, SiteType> siteIDToSiteTypeMap) {
        this._partitionInformationTree.addPartitionInformationNode(partInfo, siteIDToSiteTypeMap);
    }

    public synchronized SiteTypeVolumeID computeSiteTypeVolumeID() {
        return this._partitionInformationTree.computeSiteTypeVolumeID();
    }

    protected synchronized void _setUninitialized(int parameterIndex, boolean isBatch) {
        if (this._isClientRouting(isBatch)) {
            this._partitionInformationTree.setUninitialized(parameterIndex);
        }
    }

    protected synchronized void _setByteShortIntLong(boolean forByte, int parameterIndex, long x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setByteShortIntLongForRangePartitionCalculation(parameterIndex, x);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setByteShortIntLongForHashPartitionCalculation(forByte, parameterIndex, x);
        }
    }

    protected synchronized void _setDouble(int parameterIndex, double x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setDoubleForRangePartitionCalculation(parameterIndex, x);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setDoubleForHashPartitionCalculation(parameterIndex, x);
        }
    }

    protected synchronized void _setBigDecimal(int parameterIndex, BigDecimal x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setBigDecimalForRangePartitionCalculation(parameterIndex, x);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setBigDecimalForHashPartitionCalculation(parameterIndex, x);
        }
    }

    protected synchronized void _setTimestamp(int parameterIndex, Timestamp x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setTimestampForRangePartitionCalculation(parameterIndex, x);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setTimestampForHashPartitionCalculation(parameterIndex, x);
        }
    }

    protected synchronized void _setString(int parameterIndex, String x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setStringForRangePartitionCalculation(parameterIndex, x);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setStringForHashPartitionCalculation(parameterIndex, x);
        }
    }

    protected synchronized void _setBytes(int parameterIndex, byte[] x, boolean isBatch) throws SQLException {
        if (this._isClientRoutingByRange(isBatch)) {
            this._partitionInformationTree.setBytesForRangePartitionCalculation(parameterIndex);
        }
        if (this._isClientRoutingByHash(isBatch)) {
            this._partitionInformationTree.setBytesForHashPartitionCalculation(parameterIndex, x);
        }
    }

    protected synchronized void _clearParameters() throws SQLException {
        this._partitionInformationTree.clearParametersForPartitionCalculation();
    }

    protected synchronized boolean _isClientRouting(boolean isBatch) {
        return this._isClientRoutingByHash(isBatch) || this._isClientRoutingByRange(isBatch);
    }

    protected synchronized boolean _isClientRoutingByHash(boolean isBatch) {
        return this._partitionInformationTree.isHashPartitioned() && (!isBatch || this._functionCode == FunctionCode.Insert && this._connection.getBooleanConnectionProperty(ConnectionProperty.SPLIT_BATCH_COMMANDS));
    }

    protected synchronized boolean _isClientRoutingByRange(boolean isBatch) {
        return !isBatch && this._partitionInformationTree.isRangePartitioned();
    }

    protected synchronized boolean _isClientRoutingByHashWithoutSplit() {
        if (!this._partitionInformationTree.isHashPartitioned()) {
            return false;
        }
        return this._functionCode == FunctionCode.Insert && this._partitionInformationTree.getPartitionMethod() == PartitionMethod.HashWithoutSplitBatch;
    }

    protected synchronized boolean _isClientRoutingByRangeWithoutSplit() {
        if (!this._partitionInformationTree.isRangePartitioned()) {
            return false;
        }
        return this._functionCode == FunctionCode.Insert && this._partitionInformationTree.getPartitionMethod() == PartitionMethod.RangeWithoutSplitBatch;
    }

    public synchronized HashPartitionInfo getHashPartitionInfo() {
        return this._partitionInformationTree.getHashPartitionInfo();
    }

    public synchronized RangePartitionInfo getRangePartitionInfo() {
        return this._partitionInformationTree.getRangePartitionInfo();
    }

    public synchronized int getVolumeIDAffinity() {
        return this._partitionInformationTree.getVolumeIDAffinity();
    }

    public synchronized void setVolumeIDAffinity(int volumeIDAffinity) {
        this._partitionInformationTree.setVolumeIDAffinity(volumeIDAffinity);
    }
}

