/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import java.net.Proxy;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

@ThreadSafe
class HanaWebSocket
extends WebSocketClient {
    private final Tracer _tracer;
    @GuardedBy(value="this")
    private final Queue<ByteBuffer> _queue;
    @GuardedBy(value="this")
    private boolean _isOpened;
    @GuardedBy(value="this")
    private boolean _isClosed;
    @GuardedBy(value="this")
    private ByteBuffer _buffer;
    @GuardedBy(value="this")
    private Exception _exception;

    HanaWebSocket(Tracer tracer, ConnectionProperties connectionProperties, URI serverUrl, Proxy proxy) throws RTEException {
        super(serverUrl, new Draft_6455(), null, connectionProperties.getIntProperty(ConnectionProperty.CONNECT_TIMEOUT));
        this._tracer = tracer;
        this._queue = new LinkedList<ByteBuffer>();
        this._isOpened = false;
        this._isClosed = true;
        if (proxy != null) {
            super.setProxy(proxy);
        }
        try {
            super.connectBlocking();
        }
        catch (InterruptedException e) {
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", serverUrl.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        if (this._exception != null) {
            throw new RTEException(tracer, MessageTranslator.translate("error.host.connect", serverUrl.toString(), this._exception.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED);
        }
        this.setConnectionLostTimeout(connectionProperties.getIntProperty(ConnectionProperty.WEB_SOCKET_PING_TIMEOUT));
    }

    @Override
    public synchronized void onOpen(ServerHandshake handshakedata) {
        this._isOpened = true;
        this._isClosed = false;
        this.notify();
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public synchronized void onClose(int code, String reason, boolean remote) {
        this._isClosed = true;
        this.notify();
    }

    @Override
    public synchronized void onError(Exception e) {
        this._exception = e;
        this.close();
    }

    @Override
    public synchronized void onMessage(ByteBuffer buffer) {
        this._queue.add(buffer);
        this.notify();
    }

    @Override
    public void onFragment(Framedata fragment) {
    }

    synchronized void _writeSocket(byte[] buffer, int len) throws RTEException {
        while (!this._isOpened && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
            }
        }
        if (this._isClosed) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", new Object[0]), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        if (this._exception != null) {
            throw new RTEException(this._tracer, MessageTranslator.translate("error.send.write", this._exception.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN);
        }
        super.send(ByteBuffer.wrap(buffer, 0, len));
    }

    synchronized int _readSocket(byte[] buffer, int off, int len) throws RTEException {
        int remaining;
        int n = remaining = this._buffer != null ? this._buffer.remaining() : 0;
        if (remaining == 0) {
            while (this._queue.isEmpty() && !this._isClosed && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                }
            }
            if (this._isClosed) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLSEND_LINE_DOWN);
            }
            if (this._exception != null) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", this._exception.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            this._buffer = this._queue.poll();
            if (this._buffer == null) {
                throw new RTEException(this._tracer, MessageTranslator.translate("error.data.receivefailed.reason", new Object[0]), RteReturnCode.SQLRECEIVE_LINE_DOWN);
            }
            remaining = this._buffer.remaining();
        }
        int returned = Math.min(len, remaining);
        this._buffer.get(buffer, off, returned);
        return returned;
    }
}

