/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.resultset;

import com.redislabs.redisgraph.Statistics;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import redis.clients.jedis.util.SafeEncoder;

public class StatisticsImpl
implements Statistics {
    private final List<byte[]> raw;
    private final Map<Statistics.Label, String> statistics;

    public StatisticsImpl(List<byte[]> raw) {
        this.raw = raw;
        this.statistics = new EnumMap<Statistics.Label, String>(Statistics.Label.class);
    }

    @Override
    public String getStringValue(Statistics.Label label) {
        return this.getStatistics().get((Object)label);
    }

    private Map<Statistics.Label, String> getStatistics() {
        if (this.statistics.size() == 0) {
            for (byte[] tuple : this.raw) {
                Statistics.Label label;
                String text = SafeEncoder.encode((byte[])tuple);
                String[] rowTuple = text.split(":");
                if (rowTuple.length != 2 || (label = Statistics.Label.getEnum(rowTuple[0])) == null) continue;
                this.statistics.put(label, rowTuple[1].trim());
            }
        }
        return this.statistics;
    }

    public int getIntValue(Statistics.Label label) {
        String value = this.getStringValue(label);
        return value == null ? 0 : Integer.parseInt(value);
    }

    @Override
    public int nodesCreated() {
        return this.getIntValue(Statistics.Label.NODES_CREATED);
    }

    @Override
    public int nodesDeleted() {
        return this.getIntValue(Statistics.Label.NODES_DELETED);
    }

    @Override
    public int indicesAdded() {
        return this.getIntValue(Statistics.Label.INDICES_ADDED);
    }

    @Override
    public int indicesDeleted() {
        return this.getIntValue(Statistics.Label.INDICES_DELETED);
    }

    @Override
    public int labelsAdded() {
        return this.getIntValue(Statistics.Label.LABELS_ADDED);
    }

    @Override
    public int relationshipsDeleted() {
        return this.getIntValue(Statistics.Label.RELATIONSHIPS_DELETED);
    }

    @Override
    public int relationshipsCreated() {
        return this.getIntValue(Statistics.Label.RELATIONSHIPS_CREATED);
    }

    @Override
    public int propertiesSet() {
        return this.getIntValue(Statistics.Label.PROPERTIES_SET);
    }

    @Override
    public boolean cachedExecution() {
        return this.getIntValue(Statistics.Label.CACHED_EXECUTION) == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatisticsImpl)) {
            return false;
        }
        StatisticsImpl that = (StatisticsImpl)o;
        return Objects.equals(this.raw, that.raw) && Objects.equals(this.getStatistics(), that.getStatistics());
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.getStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StatisticsImpl{");
        sb.append("statistics=").append(this.getStatistics());
        sb.append('}');
        return sb.toString();
    }
}

