/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.resultset;

import com.redislabs.redisgraph.Header;
import com.redislabs.redisgraph.Record;
import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.ResultSet;
import com.redislabs.redisgraph.Statistics;
import com.redislabs.redisgraph.exceptions.JRedisGraphRunTimeException;
import com.redislabs.redisgraph.graph_entities.Edge;
import com.redislabs.redisgraph.graph_entities.GraphEntity;
import com.redislabs.redisgraph.graph_entities.Node;
import com.redislabs.redisgraph.graph_entities.Path;
import com.redislabs.redisgraph.graph_entities.Property;
import com.redislabs.redisgraph.impl.graph_cache.GraphCache;
import com.redislabs.redisgraph.impl.resultset.HeaderImpl;
import com.redislabs.redisgraph.impl.resultset.RecordImpl;
import com.redislabs.redisgraph.impl.resultset.ResultSetScalarTypes;
import com.redislabs.redisgraph.impl.resultset.StatisticsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.SafeEncoder;

public class ResultSetImpl
implements ResultSet {
    private final Header header;
    private final Statistics statistics;
    private final List<Record> results;
    private int position = 0;
    private final RedisGraph redisGraph;
    private final GraphCache cache;

    public ResultSetImpl(List<Object> rawResponse, RedisGraph redisGraph, GraphCache cache) {
        this.redisGraph = redisGraph;
        this.cache = cache;
        if (rawResponse.get(rawResponse.size() - 1) instanceof JedisDataException) {
            throw new JRedisGraphRunTimeException((Throwable)rawResponse.get(rawResponse.size() - 1));
        }
        if (rawResponse.size() != 3) {
            this.header = this.parseHeader(new ArrayList<List<Object>>());
            this.results = new ArrayList<Record>();
            this.statistics = rawResponse.isEmpty() ? this.parseStatistics(new ArrayList()) : this.parseStatistics(rawResponse.get(rawResponse.size() - 1));
        } else {
            this.header = this.parseHeader((List)rawResponse.get(0));
            this.results = this.parseResult((List)rawResponse.get(1));
            this.statistics = this.parseStatistics(rawResponse.get(2));
        }
    }

    private List<Record> parseResult(List<List<Object>> rawResultSet) {
        ArrayList<Record> results = new ArrayList<Record>();
        if (rawResultSet == null || rawResultSet.isEmpty()) {
            return results;
        }
        for (List<Object> row : rawResultSet) {
            ArrayList<Object> parsedRow = new ArrayList<Object>(row.size());
            block6: for (int i = 0; i < row.size(); ++i) {
                List obj = (List)row.get(i);
                Header.ResultSetColumnTypes objType = this.header.getSchemaTypes().get(i);
                switch (objType) {
                    case COLUMN_NODE: {
                        parsedRow.add(this.deserializeNode(obj));
                        continue block6;
                    }
                    case COLUMN_RELATION: {
                        parsedRow.add(this.deserializeEdge(obj));
                        continue block6;
                    }
                    case COLUMN_SCALAR: {
                        parsedRow.add(this.deserializeScalar(obj));
                        continue block6;
                    }
                    default: {
                        parsedRow.add(null);
                    }
                }
            }
            RecordImpl record = new RecordImpl(this.header.getSchemaNames(), parsedRow);
            results.add(record);
        }
        return results;
    }

    private StatisticsImpl parseStatistics(Object rawStatistics) {
        return new StatisticsImpl((List)rawStatistics);
    }

    private HeaderImpl parseHeader(List<List<Object>> rawHeader) {
        return new HeaderImpl(rawHeader);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    private Node deserializeNode(List<Object> rawNodeData) {
        Node node = new Node();
        this.deserializeGraphEntityId(node, rawNodeData.get(0));
        List labelsIndices = (List)rawNodeData.get(1);
        for (Long labelIndex : labelsIndices) {
            String label = this.cache.getLabel(labelIndex.intValue(), this.redisGraph);
            node.addLabel(label);
        }
        this.deserializeGraphEntityProperties(node, (List)rawNodeData.get(2));
        return node;
    }

    private void deserializeGraphEntityId(GraphEntity graphEntity, Object rawEntityId) {
        long id = (Long)rawEntityId;
        graphEntity.setId(id);
    }

    private Edge deserializeEdge(List<Object> rawEdgeData) {
        Edge edge = new Edge();
        this.deserializeGraphEntityId(edge, rawEdgeData.get(0));
        String relationshipType = this.cache.getRelationshipType(((Long)rawEdgeData.get(1)).intValue(), this.redisGraph);
        edge.setRelationshipType(relationshipType);
        edge.setSource((Long)rawEdgeData.get(2));
        edge.setDestination((Long)rawEdgeData.get(3));
        this.deserializeGraphEntityProperties(edge, (List)rawEdgeData.get(4));
        return edge;
    }

    private void deserializeGraphEntityProperties(GraphEntity entity, List<List<Object>> rawProperties) {
        for (List<Object> rawProperty : rawProperties) {
            Property<Object> property = new Property<Object>();
            property.setName(this.cache.getPropertyName(((Long)rawProperty.get(0)).intValue(), this.redisGraph));
            List<Object> propertyScalar = rawProperty.subList(1, rawProperty.size());
            property.setValue(this.deserializeScalar(propertyScalar));
            entity.addProperty(property);
        }
    }

    private Object deserializeScalar(List<Object> rawScalarData) {
        ResultSetScalarTypes type = this.getValueTypeFromObject(rawScalarData.get(0));
        Object obj = rawScalarData.get(1);
        switch (type) {
            case VALUE_NULL: {
                return null;
            }
            case VALUE_BOOLEAN: {
                return Boolean.parseBoolean(SafeEncoder.encode((byte[])((byte[])obj)));
            }
            case VALUE_DOUBLE: {
                return Double.parseDouble(SafeEncoder.encode((byte[])((byte[])obj)));
            }
            case VALUE_INTEGER: {
                return (Long)obj;
            }
            case VALUE_STRING: {
                return SafeEncoder.encode((byte[])((byte[])obj));
            }
            case VALUE_ARRAY: {
                return this.deserializeArray(obj);
            }
            case VALUE_NODE: {
                return this.deserializeNode((List)obj);
            }
            case VALUE_EDGE: {
                return this.deserializeEdge((List)obj);
            }
            case VALUE_PATH: {
                return this.deserializePath(obj);
            }
            case VALUE_MAP: {
                return this.deserializeMap(obj);
            }
        }
        return obj;
    }

    private Map<String, Object> deserializeMap(Object rawScalarData) {
        List keyTypeValueEntries = (List)rawScalarData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keyTypeValueEntries.size(); i += 2) {
            String key = SafeEncoder.encode((byte[])((byte[])keyTypeValueEntries.get(i)));
            Object value = this.deserializeScalar((List)keyTypeValueEntries.get(i + 1));
            map.put(key, value);
        }
        return map;
    }

    private Path deserializePath(Object rawScalarData) {
        List array = (List)rawScalarData;
        List nodes = (List)this.deserializeScalar((List)array.get(0));
        List edges = (List)this.deserializeScalar((List)array.get(1));
        return new Path(nodes, edges);
    }

    private List<Object> deserializeArray(Object rawScalarData) {
        List array = (List)rawScalarData;
        ArrayList<Object> res = new ArrayList<Object>(array.size());
        for (List arrayValue : array) {
            res.add(this.deserializeScalar(arrayValue));
        }
        return res;
    }

    private ResultSetScalarTypes getValueTypeFromObject(Object rawScalarType) {
        return ResultSetScalarTypes.getValue(((Long)rawScalarType).intValue());
    }

    @Override
    @Deprecated
    public boolean hasNext() {
        return this.position < this.results.size();
    }

    @Override
    @Deprecated
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.results.get(this.position++);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultSetImpl)) {
            return false;
        }
        ResultSetImpl resultSet = (ResultSetImpl)o;
        return Objects.equals(this.getHeader(), resultSet.getHeader()) && Objects.equals(this.getStatistics(), resultSet.getStatistics()) && Objects.equals(this.results, resultSet.results);
    }

    public int hashCode() {
        return Objects.hash(this.getHeader(), this.getStatistics(), this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultSetImpl{");
        sb.append("header=").append(this.header);
        sb.append(", statistics=").append(this.statistics);
        sb.append(", results=").append(this.results);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Record> iterator() {
        return this.results.iterator();
    }
}

