/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.resultset;

import com.redislabs.redisgraph.Record;
import java.util.List;
import java.util.Objects;

public class RecordImpl
implements Record {
    private final List<String> header;
    private final List<Object> values;

    public RecordImpl(List<String> header, List<Object> values) {
        this.header = header;
        this.values = values;
    }

    @Override
    public <T> T getValue(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public <T> T getValue(String key) {
        return this.getValue(this.header.indexOf(key));
    }

    @Override
    public String getString(int index) {
        return this.values.get(index).toString();
    }

    @Override
    public String getString(String key) {
        return this.getString(this.header.indexOf(key));
    }

    @Override
    public List<String> keys() {
        return this.header;
    }

    @Override
    public List<Object> values() {
        return this.values;
    }

    @Override
    public boolean containsKey(String key) {
        return this.header.contains(key);
    }

    @Override
    public int size() {
        return this.header.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordImpl)) {
            return false;
        }
        RecordImpl record = (RecordImpl)o;
        return Objects.equals(this.header, record.header) && Objects.equals(this.values, record.values);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Record{");
        sb.append("values=").append(this.values);
        sb.append('}');
        return sb.toString();
    }
}

