/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.resultset;

import com.redislabs.redisgraph.Header;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import redis.clients.jedis.util.SafeEncoder;

public class HeaderImpl
implements Header {
    private final List<List<Object>> raw;
    private final List<Header.ResultSetColumnTypes> schemaTypes = new ArrayList<Header.ResultSetColumnTypes>();
    private final List<String> schemaNames = new ArrayList<String>();

    public HeaderImpl(List<List<Object>> raw) {
        this.raw = raw;
    }

    @Override
    public List<String> getSchemaNames() {
        if (this.schemaNames.isEmpty()) {
            this.buildSchema();
        }
        return this.schemaNames;
    }

    @Override
    public List<Header.ResultSetColumnTypes> getSchemaTypes() {
        if (this.schemaTypes.isEmpty()) {
            this.buildSchema();
        }
        return this.schemaTypes;
    }

    private void buildSchema() {
        for (List<Object> tuple : this.raw) {
            Header.ResultSetColumnTypes type = Header.ResultSetColumnTypes.values()[((Long)tuple.get(0)).intValue()];
            String text = SafeEncoder.encode((byte[])((byte[])tuple.get(1)));
            if (type == null) continue;
            this.schemaTypes.add(type);
            this.schemaNames.add(text);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderImpl)) {
            return false;
        }
        HeaderImpl header = (HeaderImpl)o;
        return Objects.equals(this.getSchemaTypes(), header.getSchemaTypes()) && Objects.equals(this.getSchemaNames(), header.getSchemaNames());
    }

    public int hashCode() {
        return Objects.hash(this.getSchemaTypes(), this.getSchemaNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HeaderImpl{");
        sb.append("schemaTypes=").append(this.schemaTypes);
        sb.append(", schemaNames=").append(this.schemaNames);
        sb.append('}');
        return sb.toString();
    }
}

