/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.graph_cache;

import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.impl.graph_cache.GraphCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RedisGraphCaches {
    private final Map<String, GraphCache> graphCaches = new ConcurrentHashMap<String, GraphCache>();

    public GraphCache getGraphCache(String graphId) {
        if (!this.graphCaches.containsKey(graphId)) {
            this.graphCaches.putIfAbsent(graphId, new GraphCache(graphId));
        }
        return this.graphCaches.get(graphId);
    }

    public String getLabel(String graphId, int index, RedisGraph redisGraph) {
        return this.getGraphCache(graphId).getLabel(index, redisGraph);
    }

    public String getRelationshipType(String graphId, int index, RedisGraph redisGraph) {
        return this.getGraphCache(graphId).getRelationshipType(index, redisGraph);
    }

    public String getPropertyName(String graphId, int index, RedisGraph redisGraph) {
        return this.getGraphCache(graphId).getPropertyName(index, redisGraph);
    }

    public void removeGraphCache(String graphId) {
        this.graphCaches.remove(graphId);
    }
}

