/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.graph_cache;

import com.redislabs.redisgraph.Record;
import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class GraphCacheList {
    private final String graphId;
    private final String procedure;
    private final List<String> data = new CopyOnWriteArrayList<String>();

    public GraphCacheList(String graphId, String procedure) {
        this.graphId = graphId;
        this.procedure = procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedData(int index, RedisGraph redisGraph) {
        if (index >= this.data.size()) {
            List<String> list = this.data;
            synchronized (list) {
                if (index >= this.data.size()) {
                    this.getProcedureInfo(redisGraph);
                }
            }
        }
        return this.data.get(index);
    }

    private void getProcedureInfo(RedisGraph redisGraph) {
        ResultSet resultSet = redisGraph.callProcedure(this.graphId, this.procedure);
        ArrayList<String> newData = new ArrayList<String>();
        int i = 0;
        while (resultSet.hasNext()) {
            Record record = (Record)resultSet.next();
            if (i >= this.data.size()) {
                newData.add(record.getString(0));
            }
            ++i;
        }
        this.data.addAll(newData);
    }
}

