/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.graph_cache;

import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.impl.graph_cache.GraphCacheList;

public class GraphCache {
    private final GraphCacheList labels;
    private final GraphCacheList propertyNames;
    private final GraphCacheList relationshipTypes;

    public GraphCache(String graphId) {
        this.labels = new GraphCacheList(graphId, "db.labels");
        this.propertyNames = new GraphCacheList(graphId, "db.propertyKeys");
        this.relationshipTypes = new GraphCacheList(graphId, "db.relationshipTypes");
    }

    public String getLabel(int index, RedisGraph redisGraph) {
        return this.labels.getCachedData(index, redisGraph);
    }

    public String getRelationshipType(int index, RedisGraph redisGraph) {
        return this.relationshipTypes.getCachedData(index, redisGraph);
    }

    public String getPropertyName(int index, RedisGraph redisGraph) {
        return this.propertyNames.getCachedData(index, redisGraph);
    }
}

