/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.api;

import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.ResultSet;
import com.redislabs.redisgraph.impl.Utils;
import com.redislabs.redisgraph.impl.api.RedisGraphCacheHolder;
import com.redislabs.redisgraph.impl.api.RedisGraphCommand;
import com.redislabs.redisgraph.impl.graph_cache.RedisGraphCaches;
import com.redislabs.redisgraph.impl.resultset.ResultSetImpl;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.ProtocolCommand;

public class RedisGraphTransaction
extends Transaction
implements com.redislabs.redisgraph.RedisGraphTransaction,
RedisGraphCacheHolder {
    private final RedisGraph redisGraph;
    private RedisGraphCaches caches;

    public RedisGraphTransaction(Client client, RedisGraph redisGraph) {
        super(client);
        this.redisGraph = redisGraph;
    }

    @Override
    public Response<ResultSet> query(final String graphId, String query) {
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, query, "--COMPACT"});
        return this.getResponse((Builder)new Builder<ResultSet>(){

            public ResultSet build(Object o) {
                return new ResultSetImpl((List)o, RedisGraphTransaction.this.redisGraph, RedisGraphTransaction.this.caches.getGraphCache(graphId));
            }
        });
    }

    @Override
    public Response<ResultSet> query(final String graphId, String query, long timeout) {
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, query, "--COMPACT", "TIMEOUT", Long.toString(timeout)});
        return this.getResponse((Builder)new Builder<ResultSet>(){

            public ResultSet build(Object o) {
                return new ResultSetImpl((List)o, RedisGraphTransaction.this.redisGraph, RedisGraphTransaction.this.caches.getGraphCache(graphId));
            }
        });
    }

    @Override
    @Deprecated
    public Response<ResultSet> query(final String graphId, String query, Object ... args) {
        String preparedQuery = Utils.prepareQuery(query, args);
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, preparedQuery, "--COMPACT"});
        return this.getResponse((Builder)new Builder<ResultSet>(){

            public ResultSet build(Object o) {
                return new ResultSetImpl((List)o, RedisGraphTransaction.this.redisGraph, RedisGraphTransaction.this.caches.getGraphCache(graphId));
            }
        });
    }

    @Override
    public Response<ResultSet> query(final String graphId, String query, Map<String, Object> params) {
        String preparedQuery = Utils.prepareQuery(query, params);
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, preparedQuery, "--COMPACT"});
        return this.getResponse((Builder)new Builder<ResultSet>(){

            public ResultSet build(Object o) {
                return new ResultSetImpl((List)o, RedisGraphTransaction.this.redisGraph, RedisGraphTransaction.this.caches.getGraphCache(graphId));
            }
        });
    }

    @Override
    public Response<ResultSet> query(final String graphId, String query, Map<String, Object> params, long timeout) {
        String preparedQuery = Utils.prepareQuery(query, params);
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, preparedQuery, "--COMPACT", "TIMEOUT", Long.toString(timeout)});
        return this.getResponse((Builder)new Builder<ResultSet>(){

            public ResultSet build(Object o) {
                return new ResultSetImpl((List)o, RedisGraphTransaction.this.redisGraph, RedisGraphTransaction.this.caches.getGraphCache(graphId));
            }
        });
    }

    @Override
    public Response<ResultSet> callProcedure(String graphId, String procedure) {
        return this.callProcedure(graphId, procedure, Utils.DUMMY_LIST, Utils.DUMMY_MAP);
    }

    @Override
    public Response<ResultSet> callProcedure(String graphId, String procedure, List<String> args) {
        return this.callProcedure(graphId, procedure, args, Utils.DUMMY_MAP);
    }

    @Override
    public Response<ResultSet> callProcedure(String graphId, String procedure, List<String> args, Map<String, List<String>> kwargs) {
        String preparedProcedure = Utils.prepareProcedure(procedure, args, kwargs);
        return this.query(graphId, preparedProcedure);
    }

    @Override
    public Response<String> deleteGraph(String graphId) {
        this.client.sendCommand((ProtocolCommand)RedisGraphCommand.DELETE, new String[]{graphId});
        Response response = this.getResponse(BuilderFactory.STRING);
        this.caches.removeGraphCache(graphId);
        return response;
    }

    @Override
    public void setRedisGraphCaches(RedisGraphCaches caches) {
        this.caches = caches;
    }
}

