/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.api;

import com.redislabs.redisgraph.RedisGraphContext;
import com.redislabs.redisgraph.RedisGraphContextGenerator;
import com.redislabs.redisgraph.ResultSet;
import com.redislabs.redisgraph.impl.api.AbstractRedisGraph;
import com.redislabs.redisgraph.impl.api.ContextedRedisGraph;
import com.redislabs.redisgraph.impl.api.RedisGraphCommand;
import com.redislabs.redisgraph.impl.graph_cache.RedisGraphCaches;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class RedisGraph
extends AbstractRedisGraph
implements RedisGraphContextGenerator {
    private final Pool<Jedis> client;
    private final RedisGraphCaches caches = new RedisGraphCaches();

    public RedisGraph() {
        this("localhost", 6379);
    }

    public RedisGraph(String host, int port) {
        this((Pool<Jedis>)new JedisPool(host, port));
    }

    public RedisGraph(Pool<Jedis> jedis) {
        this.client = jedis;
    }

    @Override
    protected Jedis getConnection() {
        return (Jedis)this.client.getResource();
    }

    @Override
    protected ResultSet sendQuery(String graphId, String preparedQuery) {
        try (ContextedRedisGraph contextedRedisGraph = new ContextedRedisGraph(this.getConnection());){
            contextedRedisGraph.setRedisGraphCaches(this.caches);
            ResultSet resultSet = contextedRedisGraph.sendQuery(graphId, preparedQuery);
            return resultSet;
        }
    }

    @Override
    protected ResultSet sendQuery(String graphId, String preparedQuery, long timeout) {
        try (ContextedRedisGraph contextedRedisGraph = new ContextedRedisGraph(this.getConnection());){
            contextedRedisGraph.setRedisGraphCaches(this.caches);
            ResultSet resultSet = contextedRedisGraph.sendQuery(graphId, preparedQuery, timeout);
            return resultSet;
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public String deleteGraph(String graphId) {
        try (Jedis conn = this.getConnection();){
            Object response = conn.sendCommand((ProtocolCommand)RedisGraphCommand.DELETE, new String[]{graphId});
            this.caches.removeGraphCache(graphId);
            String string = SafeEncoder.encode((byte[])((byte[])response));
            return string;
        }
    }

    @Override
    public RedisGraphContext getContext() {
        ContextedRedisGraph contextedRedisGraph = new ContextedRedisGraph(this.getConnection());
        contextedRedisGraph.setRedisGraphCaches(this.caches);
        return contextedRedisGraph;
    }
}

