/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.api;

import com.redislabs.redisgraph.RedisGraphContext;
import com.redislabs.redisgraph.ResultSet;
import com.redislabs.redisgraph.exceptions.JRedisGraphCompileTimeException;
import com.redislabs.redisgraph.exceptions.JRedisGraphRunTimeException;
import com.redislabs.redisgraph.impl.api.AbstractRedisGraph;
import com.redislabs.redisgraph.impl.api.RedisGraphCacheHolder;
import com.redislabs.redisgraph.impl.api.RedisGraphCommand;
import com.redislabs.redisgraph.impl.api.RedisGraphTransaction;
import com.redislabs.redisgraph.impl.graph_cache.RedisGraphCaches;
import com.redislabs.redisgraph.impl.resultset.ResultSetImpl;
import java.util.List;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.SafeEncoder;

public class ContextedRedisGraph
extends AbstractRedisGraph
implements RedisGraphContext,
RedisGraphCacheHolder {
    private final Jedis connectionContext;
    private RedisGraphCaches caches;

    public ContextedRedisGraph(Jedis connectionContext) {
        this.connectionContext = connectionContext;
    }

    @Override
    protected Jedis getConnection() {
        return this.connectionContext;
    }

    @Override
    protected ResultSet sendQuery(String graphId, String preparedQuery) {
        Jedis conn = this.getConnection();
        try {
            List rawResponse = (List)conn.sendCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, preparedQuery, "--COMPACT"});
            return new ResultSetImpl(rawResponse, this, this.caches.getGraphCache(graphId));
        }
        catch (JRedisGraphRunTimeException rt) {
            throw rt;
        }
        catch (JedisDataException j) {
            throw new JRedisGraphCompileTimeException(j);
        }
    }

    @Override
    protected ResultSet sendQuery(String graphId, String preparedQuery, long timeout) {
        Jedis conn = this.getConnection();
        try {
            List rawResponse = (List)conn.sendBlockingCommand((ProtocolCommand)RedisGraphCommand.QUERY, new String[]{graphId, preparedQuery, "--COMPACT", "TIMEOUT", Long.toString(timeout)});
            return new ResultSetImpl(rawResponse, this, this.caches.getGraphCache(graphId));
        }
        catch (JRedisGraphRunTimeException rt) {
            throw rt;
        }
        catch (JedisDataException j) {
            throw new JRedisGraphCompileTimeException(j);
        }
    }

    @Override
    public Jedis getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public RedisGraphTransaction multi() {
        Jedis jedis = this.getConnection();
        Client client = jedis.getClient();
        client.multi();
        client.getOne();
        RedisGraphTransaction transaction = new RedisGraphTransaction(client, this);
        transaction.setRedisGraphCaches(this.caches);
        return transaction;
    }

    @Override
    public String watch(String ... keys) {
        return this.getConnection().watch(keys);
    }

    @Override
    public String unwatch() {
        return this.getConnection().unwatch();
    }

    @Override
    public String deleteGraph(String graphId) {
        Object response;
        Jedis conn = this.getConnection();
        try {
            response = conn.sendCommand((ProtocolCommand)RedisGraphCommand.DELETE, new String[]{graphId});
        }
        catch (Exception e) {
            conn.close();
            throw e;
        }
        this.caches.removeGraphCache(graphId);
        return SafeEncoder.encode((byte[])((byte[])response));
    }

    @Override
    public void close() {
        this.connectionContext.close();
    }

    @Override
    public void setRedisGraphCaches(RedisGraphCaches caches) {
        this.caches = caches;
    }
}

