/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl.api;

import com.redislabs.redisgraph.RedisGraph;
import com.redislabs.redisgraph.ResultSet;
import com.redislabs.redisgraph.impl.Utils;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Jedis;

public abstract class AbstractRedisGraph
implements RedisGraph {
    protected abstract Jedis getConnection();

    protected abstract ResultSet sendQuery(String var1, String var2);

    protected abstract ResultSet sendQuery(String var1, String var2, long var3);

    @Override
    public ResultSet query(String graphId, String query) {
        return this.sendQuery(graphId, query);
    }

    @Override
    public ResultSet query(String graphId, String query, long timeout) {
        return this.sendQuery(graphId, query, timeout);
    }

    @Override
    @Deprecated
    public ResultSet query(String graphId, String query, Object ... args) {
        String preparedQuery = Utils.prepareQuery(query, args);
        return this.sendQuery(graphId, preparedQuery);
    }

    @Override
    public ResultSet query(String graphId, String query, Map<String, Object> params) {
        String preparedQuery = Utils.prepareQuery(query, params);
        return this.sendQuery(graphId, preparedQuery);
    }

    @Override
    public ResultSet query(String graphId, String query, Map<String, Object> params, long timeout) {
        String preparedQuery = Utils.prepareQuery(query, params);
        return this.sendQuery(graphId, preparedQuery, timeout);
    }

    @Override
    public ResultSet callProcedure(String graphId, String procedure) {
        return this.callProcedure(graphId, procedure, Utils.DUMMY_LIST, Utils.DUMMY_MAP);
    }

    @Override
    public ResultSet callProcedure(String graphId, String procedure, List<String> args) {
        return this.callProcedure(graphId, procedure, args, Utils.DUMMY_MAP);
    }

    @Override
    public ResultSet callProcedure(String graphId, String procedure, List<String> args, Map<String, List<String>> kwargs) {
        String preparedProcedure = Utils.prepareProcedure(procedure, args, kwargs);
        return this.query(graphId, preparedProcedure);
    }
}

