/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redisgraph.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;

public class Utils {
    public static final List<String> DUMMY_LIST = new ArrayList<String>(0);
    public static final Map<String, List<String>> DUMMY_MAP = new HashMap<String, List<String>>(0);
    public static final String COMPACT_STRING = "--COMPACT";
    public static final String TIMEOUT_STRING = "TIMEOUT";
    private static final CharSequenceTranslator ESCAPE_CHYPER;

    private Utils() {
    }

    private static String quoteString(String str) {
        StringBuilder sb = new StringBuilder(str.length() + 2);
        sb.append('\"');
        sb.append(str.replace("\"", "\\\""));
        sb.append('\"');
        return sb.toString();
    }

    @Deprecated
    public static String prepareQuery(String query, Object ... args) {
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) continue;
                args[i] = "'" + ESCAPE_CHYPER.translate((CharSequence)((String)args[i])) + "'";
            }
            query = String.format(query, args);
        }
        return query;
    }

    public static String prepareQuery(String query, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder("CYPHER ");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sb.append(key).append('=');
            sb.append(Utils.valueToString(value));
            sb.append(' ');
        }
        sb.append(query);
        return sb.toString();
    }

    private static String arrayToString(Object[] arr) {
        StringBuilder sb = new StringBuilder().append('[');
        sb.append(String.join((CharSequence)", ", Arrays.stream(arr).map(Utils::valueToString).collect(Collectors.toList())));
        sb.append(']');
        return sb.toString();
    }

    private static String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return Utils.quoteString((String)value);
        }
        if (value instanceof Character) {
            return Utils.quoteString(((Character)value).toString());
        }
        if (value instanceof Object[]) {
            return Utils.arrayToString((Object[])value);
        }
        if (value instanceof List) {
            List list = (List)value;
            return Utils.arrayToString(list.toArray());
        }
        return value.toString();
    }

    public static String prepareProcedure(String procedure, List<String> args, Map<String, List<String>> kwargs) {
        int i;
        args = args.stream().map(Utils::quoteString).collect(Collectors.toList());
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append("CALL ").append(procedure).append('(');
        for (i = 0; i < args.size() - 1; ++i) {
            queryStringBuilder.append(args.get(i)).append(',');
        }
        if (i == args.size() - 1) {
            queryStringBuilder.append(args.get(i));
        }
        queryStringBuilder.append(')');
        List kwargsList = kwargs.getOrDefault("y", null);
        if (kwargsList != null) {
            for (i = 0; i < kwargsList.size() - 1; ++i) {
                queryStringBuilder.append((String)kwargsList.get(i)).append(',');
            }
            queryStringBuilder.append((String)kwargsList.get(i));
        }
        return queryStringBuilder.toString();
    }

    static {
        HashMap<String, String> escapeJavaMap = new HashMap<String, String>();
        escapeJavaMap.put("'", "\\'");
        escapeJavaMap.put("\"", "\\\"");
        ESCAPE_CHYPER = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJavaMap))});
    }
}

