/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream.predicates.numeric;

import com.redis.om.spring.metamodel.SearchFieldAccessor;
import com.redis.om.spring.search.stream.predicates.BaseAbstractPredicate;
import com.redis.om.spring.search.stream.predicates.jedis.JedisValues;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import redis.clients.jedis.search.querybuilder.Node;
import redis.clients.jedis.search.querybuilder.QueryBuilders;
import redis.clients.jedis.search.querybuilder.Value;
import redis.clients.jedis.search.querybuilder.Values;

public class LessThanPredicate<E, T>
extends BaseAbstractPredicate<E, T> {
    private final T value;

    public LessThanPredicate(SearchFieldAccessor field, T value) {
        super(field);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Node apply(Node root) {
        if (ObjectUtils.isEmpty(this.getValue())) {
            return root;
        }
        Class<?> cls = this.value.getClass();
        if (cls == LocalDate.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.lt((LocalDate)this.getValue())});
        }
        if (cls == Date.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.lt((Date)this.getValue())});
        }
        if (cls == LocalDateTime.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.lt((LocalDateTime)this.getValue())});
        }
        if (cls == Instant.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{JedisValues.lt((Instant)this.getValue())});
        }
        if (cls == Integer.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.lt((int)Integer.parseInt(this.getValue().toString()))});
        }
        if (cls == Long.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.lt((double)Long.parseLong(this.getValue().toString()))});
        }
        if (cls == Double.class) {
            return QueryBuilders.intersect((Node[])new Node[]{root}).add(this.getSearchAlias(), new Value[]{Values.lt((double)Double.parseDouble(this.getValue().toString()))});
        }
        return root;
    }
}

