/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.search.stream;

import com.redis.om.spring.metamodel.MetamodelField;
import com.redis.om.spring.metamodel.MetamodelUtils;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;

public class FluentQueryByExample<T>
implements FluentQuery.FetchableFluentQuery<T> {
    private final SearchStream<T> searchStream;
    private final Class<T> probeType;
    private final SearchOperations<String> searchOps;

    public FluentQueryByExample(Example<T> example, Class<T> probeType, EntityStream entityStream, SearchOperations<String> searchOps) {
        this.probeType = probeType;
        this.searchOps = searchOps;
        this.searchStream = entityStream.of(probeType);
        this.searchStream.filter(example);
    }

    public FluentQuery.FetchableFluentQuery<T> sortBy(Sort sort) {
        this.searchStream.sorted(sort);
        return this;
    }

    public <R> FluentQuery.FetchableFluentQuery<R> as(Class<R> resultType) {
        throw new UnsupportedOperationException("`as` is not supported on a Redis Repositories");
    }

    public FluentQuery.FetchableFluentQuery<T> project(Collection<String> properties) {
        List<MetamodelField<?, ?>> metamodelFields = MetamodelUtils.getMetamodelFieldsForProperties(this.probeType, properties);
        metamodelFields.forEach(mmf -> this.searchStream.project(mmf));
        return this;
    }

    public T oneValue() {
        List result = this.searchStream.collect(Collectors.toList());
        if (ObjectUtils.isEmpty(result)) {
            return null;
        }
        if (result.size() > 1) {
            throw new IncorrectResultSizeDataAccessException("Query returned non unique result", 1);
        }
        return result.iterator().next();
    }

    public T firstValue() {
        return this.searchStream.findFirst().orElse(null);
    }

    public List<T> all() {
        return this.searchStream.collect(Collectors.toList());
    }

    public Page<T> page(Pageable pageable) {
        Query query = this.searchStream.backingQuery().isBlank() ? new Query() : new Query(this.searchStream.backingQuery());
        query.limit(Integer.valueOf(0), Integer.valueOf(0));
        SearchResult searchResult = this.searchOps.search(query);
        long count = searchResult.getTotalResults();
        List pageContents = this.searchStream.limit(pageable.getPageSize()).skip(pageable.getOffset()).collect(Collectors.toList());
        return new PageImpl(pageContents, pageable, count);
    }

    public Stream<T> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.searchStream.count();
    }

    public boolean exists() {
        return this.searchStream.count() > 0L;
    }
}

