/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.cuckoo;

import com.redis.om.spring.annotations.Cuckoo;
import com.redis.om.spring.ops.pds.CuckooFilterOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CuckooAspect
implements Ordered {
    private final CuckooFilterOperations<String> ops;
    private static final Log logger = LogFactory.getLog(CuckooAspect.class);

    public CuckooAspect(CuckooFilterOperations<String> ops) {
        this.ops = ops;
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.save(..))")
    public void inCrudRepositorySave() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.save(..))")
    public void inRedisDocumentRepositorySave() {
    }

    @Pointcut(value="inCrudRepositorySave() || inRedisDocumentRepositorySave()")
    private void inSaveOperation() {
    }

    @AfterReturning(value="inSaveOperation() && args(entity,..)")
    public void addToCuckoo(JoinPoint jp, Object entity) {
        for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
            if (!field.isAnnotationPresent(Cuckoo.class)) continue;
            Cuckoo cuckoo = field.getAnnotation(Cuckoo.class);
            String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)cuckoo.name()) ? cuckoo.name() : String.format("cf:%s:%s", entity.getClass().getSimpleName(), field.getName());
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                this.ops.add(filterName, pd.getReadMethod().invoke(entity, new Object[0]).toString());
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error((Object)String.format("Could not add value to Cuckoo filter %s", filterName), (Throwable)e);
            }
        }
    }

    @Pointcut(value="execution(public * org.springframework.data.repository.CrudRepository+.saveAll(..))")
    public void inCrudRepositorySaveAll() {
    }

    @Pointcut(value="execution(public * com.redis.om.spring.repository.RedisDocumentRepository+.saveAll(..))")
    public void inRedisDocumentRepositorySaveAll() {
    }

    @Pointcut(value="inCrudRepositorySaveAll() || inRedisDocumentRepositorySaveAll()")
    private void inSaveAllOperation() {
    }

    @AfterReturning(value="inSaveAllOperation() && args(entities,..)")
    public void addAllToCuckoo(JoinPoint jp, List<Object> entities) {
        for (Object entity : entities) {
            for (Field field : ObjectUtils.getDeclaredFieldsTransitively(entity.getClass())) {
                if (!field.isAnnotationPresent(Cuckoo.class)) continue;
                Cuckoo cuckoo = field.getAnnotation(Cuckoo.class);
                String filterName = !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)cuckoo.name()) ? cuckoo.name() : String.format("cf:%s:%s", entity.getClass().getSimpleName(), field.getName());
                try {
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), entity.getClass());
                    this.ops.add(filterName, pd.getReadMethod().invoke(entity, new Object[0]).toString());
                }
                catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.error((Object)String.format("Could not add values to Bloom filter %s", filterName), (Throwable)e);
                }
            }
        }
    }

    public int getOrder() {
        return 1;
    }
}

