/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.serialization.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.serialization.gson.ReferenceDeserializer;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.Reference;
import org.springframework.stereotype.Component;

@Component
public class ReferenceAwareGsonBuilder {
    private static final Log logger = LogFactory.getLog(ReferenceAwareGsonBuilder.class);
    private final List<Type> processedClasses = new ArrayList<Type>();
    private final GsonBuilder builder;
    private Gson gson;
    private JSONOperations<?> ops;
    private final ApplicationContext ac;
    private boolean rebuildGson = false;

    public ReferenceAwareGsonBuilder(GsonBuilder builder, ApplicationContext ac) {
        this.builder = builder;
        this.gson = builder.create();
        this.ac = ac;
    }

    public <T> void processEntity(Class<T> clazz) {
        if (!this.processedClasses.contains(clazz)) {
            this.ops = (JSONOperations)this.ac.getBean("redisJSONOperations", JSONOperations.class);
            List<Field> allClassFields = ObjectUtils.getDeclaredFieldsTransitively(clazz);
            for (Field field : allClassFields) {
                if (!field.isAnnotationPresent(Reference.class)) continue;
                logger.info((Object)String.format("Registering reference type adapter for %s", field.getType().getName()));
                this.processField(field);
            }
            this.processedClasses.add(clazz);
        }
    }

    public Gson gson() {
        if (this.rebuildGson) {
            this.gson = this.builder.create();
            this.rebuildGson = false;
        }
        return this.gson;
    }

    private void processField(Field field) {
        Optional<Type> maybeCollectionElementType;
        TypeToken typeToken = ObjectUtils.isCollection(field) ? ((maybeCollectionElementType = ObjectUtils.getCollectionElementType(field)).isPresent() ? TypeToken.getParameterized(field.getType(), (Type[])new Type[]{maybeCollectionElementType.get()}) : TypeToken.get(field.getType())) : TypeToken.get(field.getType());
        this.builder.registerTypeAdapter(typeToken.getType(), (Object)new ReferenceDeserializer(field, this.ops));
        this.rebuildGson = true;
        this.processEntity(field.getType());
    }
}

