/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.support;

import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.RedisOMSpringProperties;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.repository.query.RedisEnhancedQuery;
import com.redis.om.spring.repository.support.SimpleRedisEnhancedRepository;
import com.redis.om.spring.vectorize.FeatureExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RedisEnhancedRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<SpelQueryCreator> DEFAULT_QUERY_CREATOR = SpelQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final RedisOperations<?, ?> redisOperations;
    private final RedisModulesOperations<?> rmo;
    private final RediSearchIndexer indexer;
    private final MappingContext<?, ?> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final Class<? extends RepositoryQuery> repositoryQueryType;
    private final FeatureExtractor featureExtractor;
    private final RedisOMSpringProperties properties;

    public RedisEnhancedRepositoryFactory(KeyValueOperations keyValueOperations, RedisOperations<?, ?> redisOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, FeatureExtractor featureExtractor, RedisOMSpringProperties properties) {
        this(keyValueOperations, redisOperations, rmo, indexer, featureExtractor, DEFAULT_QUERY_CREATOR, properties);
    }

    public RedisEnhancedRepositoryFactory(KeyValueOperations keyValueOperations, RedisOperations<?, ?> redisOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, FeatureExtractor featureExtractor, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, RedisOMSpringProperties properties) {
        this(keyValueOperations, redisOperations, rmo, indexer, featureExtractor, queryCreator, RedisEnhancedQuery.class, properties);
    }

    public RedisEnhancedRepositoryFactory(KeyValueOperations keyValueOperations, RedisOperations<?, ?> redisOperations, RedisModulesOperations<?> rmo, RediSearchIndexer indexer, FeatureExtractor featureExtractor, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType, RedisOMSpringProperties properties) {
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
        Assert.notNull(redisOperations, (String)"RedisOperations must not be null!");
        Assert.notNull(rmo, (String)"RedisModulesOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null!");
        Assert.notNull((Object)featureExtractor, (String)"FeatureExtractor type must not be null!");
        Assert.notNull((Object)properties, (String)"RedisOMSpringProperties type must not be null!");
        this.keyValueOperations = keyValueOperations;
        this.redisOperations = redisOperations;
        this.rmo = rmo;
        this.indexer = indexer;
        this.context = keyValueOperations.getMappingContext();
        this.queryCreator = queryCreator;
        this.repositoryQueryType = repositoryQueryType;
        this.featureExtractor = featureExtractor;
        this.properties = properties;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        PersistentEntity entity = this.context.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.keyValueOperations, this.rmo, this.indexer, this.featureExtractor, this.properties});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleRedisEnhancedRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new RedisEnhancedQueryLookupStrategy(key, evaluationContextProvider, this.keyValueOperations, this.redisOperations, this.rmo, this.queryCreator, this.repositoryQueryType));
    }

    private static class RedisEnhancedQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final KeyValueOperations keyValueOperations;
        private final RedisModulesOperations<?> rmo;
        private final RedisOperations<?, ?> redisOperations;
        private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
        private final Class<? extends RepositoryQuery> repositoryQueryType;

        public RedisEnhancedQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, RedisOperations<?, ?> redisOperations, RedisModulesOperations<?> rmo, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
            Assert.notNull(redisOperations, (String)"RedisOperations must not be null!");
            Assert.notNull(rmo, (String)"RedisModulesOperations must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.keyValueOperations = keyValueOperations;
            this.redisOperations = redisOperations;
            this.rmo = rmo;
            this.queryCreator = queryCreator;
            this.repositoryQueryType = repositoryQueryType;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, factory);
            Constructor constructor = ClassUtils.getConstructorIfAvailable(this.repositoryQueryType, (Class[])new Class[]{QueryMethod.class, RepositoryMetadata.class, QueryMethodEvaluationContextProvider.class, KeyValueOperations.class, RedisOperations.class, RedisModulesOperations.class, Class.class});
            Assert.state((constructor != null ? 1 : 0) != 0, (String)String.format("Constructor %s(QueryMethod, EvaluationContextProvider, KeyValueOperations, RedisOperations, RedisModulesOperations, Class) not available!", ClassUtils.getShortName(this.repositoryQueryType)));
            return (RepositoryQuery)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{queryMethod, metadata, this.evaluationContextProvider, this.keyValueOperations, this.redisOperations, this.rmo, this.queryCreator});
        }
    }
}

