/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.repository.query;

import com.google.gson.Gson;
import com.redis.om.spring.annotations.Aggregation;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.Query;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.RediSearchQueryType;
import com.redis.om.spring.repository.query.SearchLanguage;
import com.redis.om.spring.repository.query.autocomplete.AutoCompleteQueryExecutor;
import com.redis.om.spring.repository.query.bloom.BloomQueryExecutor;
import com.redis.om.spring.repository.query.clause.QueryClause;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Point;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Pair;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.aggr.Group;
import redis.clients.jedis.search.aggr.Reducer;
import redis.clients.jedis.search.aggr.Reducers;
import redis.clients.jedis.search.aggr.SortedField;
import redis.clients.jedis.util.SafeEncoder;

public class RediSearchQuery
implements RepositoryQuery {
    private static final Log logger = LogFactory.getLog(RediSearchQuery.class);
    private final QueryMethod queryMethod;
    private final String searchIndex;
    private RediSearchQueryType type;
    private String value;
    private String[] returnFields;
    private Integer offset;
    private Integer limit;
    private String sortBy;
    private Boolean sortAscending;
    private final boolean hasLanguageParameter;
    private final List<Map.Entry<String, String>> aggregationLoad = new ArrayList<Map.Entry<String, String>>();
    private final List<Map.Entry<String, String>> aggregationApply = new ArrayList<Map.Entry<String, String>>();
    private String[] aggregationFilter;
    private final List<Group> aggregationGroups = new ArrayList<Group>();
    private final List<SortedField> aggregationSortedFields = new ArrayList<SortedField>();
    private Integer aggregationSortByMax;
    private Long aggregationTimeout;
    private Boolean aggregationVerbatim;
    private final List<List<Pair<String, QueryClause>>> queryOrParts = new ArrayList<List<Pair<String, QueryClause>>>();
    private final List<String> paramNames = new ArrayList<String>();
    private final Class<?> domainType;
    private final RedisModulesOperations<String> modulesOperations;
    private boolean isANDQuery = false;
    private final BloomQueryExecutor bloomQueryExecutor;
    private final AutoCompleteQueryExecutor autoCompleteQueryExecutor;
    private final Gson gson;

    public RediSearchQuery(QueryMethod queryMethod, RepositoryMetadata metadata, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, RedisModulesOperations<?> rmo, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Gson gson) {
        logger.info((Object)String.format("Creating %s query method", queryMethod.getName()));
        this.modulesOperations = rmo;
        this.queryMethod = queryMethod;
        this.searchIndex = this.queryMethod.getEntityInformation().getJavaType().getName() + "Idx";
        this.domainType = this.queryMethod.getEntityInformation().getJavaType();
        this.gson = gson;
        this.bloomQueryExecutor = new BloomQueryExecutor(this, this.modulesOperations);
        this.autoCompleteQueryExecutor = new AutoCompleteQueryExecutor(this, this.modulesOperations);
        Class repoClass = metadata.getRepositoryInterface();
        Object[] params = (Class[])queryMethod.getParameters().stream().map(Parameter::getType).toArray(Class[]::new);
        this.hasLanguageParameter = Arrays.stream(params).anyMatch(c -> c.isAssignableFrom(SearchLanguage.class));
        try {
            Method method = repoClass.getMethod(queryMethod.getName(), (Class<?>[])params);
            if (method.isAnnotationPresent(Query.class)) {
                Query queryAnnotation = method.getAnnotation(Query.class);
                this.type = RediSearchQueryType.QUERY;
                this.value = queryAnnotation.value();
                this.returnFields = queryAnnotation.returnFields();
                this.offset = queryAnnotation.offset();
                this.limit = queryAnnotation.limit();
                this.sortBy = queryAnnotation.sortBy();
                this.sortAscending = queryAnnotation.sortAscending();
            } else if (method.isAnnotationPresent(Aggregation.class)) {
                Aggregation aggregation = method.getAnnotation(Aggregation.class);
                this.type = RediSearchQueryType.AGGREGATION;
                this.value = aggregation.value();
                Arrays.stream(aggregation.load()).forEach(load -> this.aggregationLoad.add(new AbstractMap.SimpleEntry<String, String>(load.property(), load.alias())));
                Arrays.stream(aggregation.apply()).forEach(apply -> this.aggregationApply.add(new AbstractMap.SimpleEntry<String, String>(apply.alias(), apply.expression())));
                this.aggregationFilter = aggregation.filter();
                this.aggregationTimeout = aggregation.timeout() > Long.MIN_VALUE ? Long.valueOf(aggregation.timeout()) : null;
                this.aggregationVerbatim = aggregation.verbatim() ? Boolean.valueOf(true) : null;
                this.aggregationSortByMax = aggregation.sortByMax() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.sortByMax()) : null;
                this.limit = aggregation.limit() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.limit()) : null;
                this.offset = aggregation.offset() > Integer.MIN_VALUE ? Integer.valueOf(aggregation.offset()) : null;
                Arrays.stream(aggregation.groupBy()).forEach(groupBy -> {
                    Group group = new Group(groupBy.properties());
                    Arrays.stream(groupBy.reduce()).forEach(reducer -> {
                        String alias = reducer.alias();
                        String arg0 = reducer.args().length > 0 ? reducer.args()[0] : null;
                        Reducer r = null;
                        switch (reducer.func()) {
                            case COUNT: {
                                r = Reducers.count();
                                break;
                            }
                            case COUNT_DISTINCT: {
                                r = Reducers.count_distinct((String)arg0);
                                break;
                            }
                            case COUNT_DISTINCTISH: {
                                r = Reducers.count_distinctish((String)arg0);
                                break;
                            }
                            case SUM: {
                                r = Reducers.sum((String)arg0);
                                break;
                            }
                            case MIN: {
                                r = Reducers.min((String)arg0);
                                break;
                            }
                            case MAX: {
                                r = Reducers.max((String)arg0);
                                break;
                            }
                            case AVG: {
                                r = Reducers.avg((String)arg0);
                                break;
                            }
                            case STDDEV: {
                                r = Reducers.stddev((String)arg0);
                                break;
                            }
                            case QUANTILE: {
                                double percentile = Double.parseDouble(reducer.args()[1]);
                                r = Reducers.quantile((String)arg0, (double)percentile);
                                break;
                            }
                            case TOLIST: {
                                r = Reducers.to_list((String)arg0);
                                break;
                            }
                            case FIRST_VALUE: {
                                if (reducer.args().length > 1) {
                                    String arg1 = reducer.args().length > 1 ? reducer.args()[1] : null;
                                    String arg2 = reducer.args().length > 2 ? reducer.args()[2] : null;
                                    SortedField.SortOrder order = arg2 != null && arg2.equalsIgnoreCase("ASC") ? SortedField.SortOrder.ASC : SortedField.SortOrder.DESC;
                                    SortedField sortedField = new SortedField(arg1, order);
                                    r = Reducers.first_value((String)arg0, (SortedField)sortedField);
                                    break;
                                }
                                r = Reducers.first_value((String)arg0);
                                break;
                            }
                            case RANDOM_SAMPLE: {
                                int sampleSize = Integer.parseInt(reducer.args()[1]);
                                r = Reducers.random_sample((String)arg0, (int)sampleSize);
                            }
                        }
                        if (r != null && alias != null && !alias.isBlank()) {
                            r.setAlias(alias);
                        }
                        group.reduce(r);
                    });
                    this.aggregationGroups.add(group);
                });
                Arrays.stream(aggregation.sortBy()).forEach(sb -> {
                    SortedField sortedField = sb.direction().isAscending() ? SortedField.asc((String)sb.field()) : SortedField.desc((String)sb.field());
                    this.aggregationSortedFields.add(sortedField);
                });
            } else if (queryMethod.getName().equalsIgnoreCase("search")) {
                this.type = RediSearchQueryType.QUERY;
                ArrayList<Pair> orPartParts = new ArrayList<Pair>();
                orPartParts.add(Pair.of((Object)"__ALL__", (Object)((Object)QueryClause.TEXT_ALL)));
                this.queryOrParts.add(orPartParts);
                this.returnFields = new String[0];
            } else if (queryMethod.getName().startsWith("getAll")) {
                this.type = RediSearchQueryType.TAGVALS;
                this.value = ObjectUtils.lcfirst(queryMethod.getName().substring(6));
            } else if (queryMethod.getName().startsWith("autoComplete")) {
                this.type = RediSearchQueryType.AUTOCOMPLETE;
            } else {
                this.isANDQuery = QueryClause.hasContainingAllClause(queryMethod.getName());
                String methodName = this.isANDQuery ? QueryClause.getPostProcessMethodName(queryMethod.getName()) : queryMethod.getName();
                PartTree pt = new PartTree(methodName, metadata.getDomainType());
                this.processPartTree(pt);
                this.type = RediSearchQueryType.QUERY;
                this.returnFields = new String[0];
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug((Object)String.format("Could not resolved query method %s(%s): %s", queryMethod.getName(), Arrays.toString(params), e.getMessage()));
        }
    }

    private void processPartTree(PartTree pt) {
        pt.stream().forEach(orPart -> {
            ArrayList orPartParts = new ArrayList();
            orPart.iterator().forEachRemaining(part -> {
                PropertyPath propertyPath = part.getProperty();
                List<PropertyPath> path = StreamSupport.stream(propertyPath.spliterator(), false).toList();
                orPartParts.addAll(this.extractQueryFields(this.domainType, (Part)part, path));
            });
            this.queryOrParts.add(orPartParts);
        });
        Optional maybeOrder = pt.getSort().stream().findFirst();
        if (maybeOrder.isPresent()) {
            Sort.Order order = (Sort.Order)maybeOrder.get();
            this.sortBy = order.getProperty();
            this.sortAscending = order.isAscending();
        }
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path) {
        return this.extractQueryFields(type, part, path, 0);
    }

    private List<Pair<String, QueryClause>> extractQueryFields(Class<?> type, Part part, List<PropertyPath> path, int level) {
        ArrayList<Pair<String, QueryClause>> qf = new ArrayList<Pair<String, QueryClause>>();
        String property = path.get(level).getSegment();
        String key = part.getProperty().toDotPath().replace(".", "_");
        Field field = ReflectionUtils.findField(type, (String)property);
        if (field == null) {
            logger.info((Object)String.format("Did not find a field named %s", key));
            return qf;
        }
        if (field.isAnnotationPresent(TextIndexed.class)) {
            TextIndexed indexAnnotation = field.getAnnotation(TextIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TEXT, part.getType()))));
        } else if (field.isAnnotationPresent(Searchable.class)) {
            Searchable indexAnnotation = field.getAnnotation(Searchable.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TEXT, part.getType()))));
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            TagIndexed indexAnnotation = field.getAnnotation(TagIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TAG, part.getType()))));
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexed indexAnnotation = field.getAnnotation(GeoIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            NumericIndexed indexAnnotation = field.getAnnotation(NumericIndexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
        } else if (field.isAnnotationPresent(Indexed.class)) {
            Indexed indexAnnotation = field.getAnnotation(Indexed.class);
            String actualKey = indexAnnotation.alias().isBlank() ? key : indexAnnotation.alias();
            Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
            if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType.isEnum()) {
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TAG, part.getType()))));
            } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class) {
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
            } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(field);
                if (maybeCollectionType.isPresent()) {
                    Class<?> collectionType = maybeCollectionType.get();
                    if (Number.class.isAssignableFrom(collectionType)) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.NUMERIC_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.NUMERIC, part.getType()))));
                        }
                    } else if (collectionType == Point.class) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.GEO_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
                        }
                    } else if (CharSequence.class.isAssignableFrom(collectionType) || collectionType == Boolean.class) {
                        if (this.isANDQuery) {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.TAG_CONTAINING_ALL)));
                        } else {
                            qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.TAG, part.getType()))));
                        }
                    } else {
                        qf.addAll(this.extractQueryFields(collectionType, part, path, level + 1));
                    }
                }
            } else if (fieldType == Point.class) {
                qf.add((Pair<String, QueryClause>)Pair.of((Object)actualKey, (Object)((Object)QueryClause.get(Schema.FieldType.GEO, part.getType()))));
            } else {
                qf.addAll(this.extractQueryFields(fieldType, part, path, level + 1));
            }
        }
        return qf;
    }

    public Object execute(Object[] parameters) {
        Optional<String> maybeBloomFilter = this.bloomQueryExecutor.getBloomFilter();
        if (maybeBloomFilter.isPresent()) {
            return this.bloomQueryExecutor.executeBloomQuery(parameters, maybeBloomFilter.get());
        }
        if (this.type == RediSearchQueryType.QUERY) {
            return this.executeQuery(parameters);
        }
        if (this.type == RediSearchQueryType.AGGREGATION) {
            return this.executeAggregation(parameters);
        }
        if (this.type == RediSearchQueryType.TAGVALS) {
            return this.executeFtTagVals();
        }
        if (this.type == RediSearchQueryType.AUTOCOMPLETE) {
            Optional<String> maybeAutoCompleteDictionaryKey = this.autoCompleteQueryExecutor.getAutoCompleteDictionaryKey();
            return maybeAutoCompleteDictionaryKey.map(s -> this.autoCompleteQueryExecutor.executeAutoCompleteQuery(parameters, (String)s)).orElse(null);
        }
        return null;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private Object executeQuery(Object[] parameters) {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        String preparedQuery = this.prepareQuery(parameters);
        redis.clients.jedis.search.Query query = new redis.clients.jedis.search.Query(preparedQuery);
        query.returnFields(this.returnFields);
        Optional<Object> maybePageable = Optional.empty();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = (Pageable)maybePageable.get()).isUnpaged()) {
                query.limit(Integer.valueOf(Math.toIntExact(pageable.getOffset())), Integer.valueOf(pageable.getPageSize()));
                if (pageable.getSort() != null) {
                    for (Sort.Order order : pageable.getSort()) {
                        query.setSortBy(order.getProperty(), order.isAscending());
                    }
                }
            }
        }
        if (this.limit != null && this.limit != Integer.MIN_VALUE || this.offset != null && this.offset != Integer.MIN_VALUE) {
            query.limit(Integer.valueOf(this.offset != null ? this.offset : 10), Integer.valueOf(this.limit != null ? this.limit : 0));
        }
        if (this.sortBy != null && !this.sortBy.isBlank()) {
            query.setSortBy(this.sortBy, this.sortAscending.booleanValue());
        }
        if (this.hasLanguageParameter) {
            Optional<SearchLanguage> maybeSearchLanguage = Arrays.stream(parameters).filter(SearchLanguage.class::isInstance).map(SearchLanguage.class::cast).findFirst();
            maybeSearchLanguage.ifPresent(searchLanguage -> query.setLanguage(searchLanguage.getValue()));
        }
        if (this.queryMethod.isCollectionQuery() && !this.queryMethod.getParameters().isEmpty()) {
            List emptyCollectionParams = Arrays.stream(parameters).filter(Collection.class::isInstance).map(p -> (Collection)p).filter(Collection::isEmpty).collect(Collectors.toList());
            if (!emptyCollectionParams.isEmpty()) {
                return Collections.emptyList();
            }
        }
        SearchResult searchResult = ops.search(query);
        Object result = null;
        if (this.queryMethod.getReturnedObjectType() == SearchResult.class) {
            result = searchResult;
        } else if (this.queryMethod.isPageQuery()) {
            List content = searchResult.getDocuments().stream().map(d -> this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.queryMethod.getReturnedObjectType())).collect(Collectors.toList());
            if (maybePageable.isPresent()) {
                Pageable pageable = (Pageable)maybePageable.get();
                result = new PageImpl(content, pageable, searchResult.getTotalResults());
            }
        } else if (this.queryMethod.isQueryForEntity() && !this.queryMethod.isCollectionQuery()) {
            if (!searchResult.getDocuments().isEmpty()) {
                Document doc = (Document)searchResult.getDocuments().get(0);
                String json = doc != null ? SafeEncoder.encode((byte[])((byte[])doc.get("$"))) : "";
                result = this.gson.fromJson(json.toString(), this.queryMethod.getReturnedObjectType());
            }
        } else if (this.queryMethod.isQueryForEntity() && this.queryMethod.isCollectionQuery()) {
            result = searchResult.getDocuments().stream().map(d -> this.gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), this.queryMethod.getReturnedObjectType())).collect(Collectors.toList());
        }
        return result;
    }

    private Object executeAggregation(Object[] parameters) {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        AggregationBuilder aggregation = new AggregationBuilder(this.value);
        if (this.aggregationTimeout != null) {
            aggregation.timeout(this.aggregationTimeout.longValue());
        }
        if (this.aggregationVerbatim != null) {
            aggregation.verbatim();
        }
        for (Map.Entry<String, String> apply : this.aggregationLoad) {
            if (apply.getValue().isBlank()) {
                aggregation.load(new String[]{apply.getKey()});
                continue;
            }
            aggregation.load(new String[]{apply.getKey(), "AS", apply.getValue()});
        }
        this.aggregationGroups.forEach(arg_0 -> ((AggregationBuilder)aggregation).groupBy(arg_0));
        if (this.aggregationFilter != null && this.aggregationFilter.length > 0) {
            for (String filter : this.aggregationFilter) {
                aggregation.filter(filter);
            }
        }
        Optional<Object> maybePageable = Optional.empty();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable;
            maybePageable = Arrays.stream(parameters).filter(Pageable.class::isInstance).map(Pageable.class::cast).findFirst();
            if (maybePageable.isPresent() && !(pageable = (Pageable)maybePageable.get()).isUnpaged()) {
                aggregation.limit(Math.toIntExact(pageable.getOffset()), pageable.getPageSize());
                if (pageable.getSort() != null) {
                    for (Sort.Order order : pageable.getSort()) {
                        if (order.isAscending()) {
                            aggregation.sortByAsc(order.getProperty());
                            continue;
                        }
                        aggregation.sortByDesc(order.getProperty());
                    }
                }
            }
        }
        if (this.sortBy != null && !this.sortBy.isBlank()) {
            aggregation.sortByAsc(this.sortBy);
        } else if (!this.aggregationSortedFields.isEmpty()) {
            if (this.aggregationSortByMax != null) {
                aggregation.sortBy(this.aggregationSortByMax.intValue(), this.aggregationSortedFields.toArray(new SortedField[0]));
            } else {
                aggregation.sortBy(this.aggregationSortedFields.toArray(new SortedField[0]));
            }
        }
        for (Map.Entry<String, String> apply : this.aggregationApply) {
            aggregation.apply(apply.getValue(), apply.getKey());
        }
        if (this.limit != null || this.offset != null) {
            aggregation.limit(this.offset != null ? this.offset : 0, this.limit != null ? this.limit : 0);
        }
        AggregationResult aggregationResult = ops.aggregate(aggregation);
        AggregationResult result = null;
        if (this.queryMethod.getReturnedObjectType() == AggregationResult.class) {
            result = aggregationResult;
        } else if (this.queryMethod.getReturnedObjectType() == Map.class) {
            List<Object> content = List.of();
            if (this.queryMethod.getReturnedObjectType() == Map.class) {
                content = aggregationResult.getResults().stream().map(m -> m.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), e.getValue() != null ? new String((byte[])e.getValue()) : "")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).collect(Collectors.toList());
            }
            if (this.queryMethod.isPageQuery() && maybePageable.isPresent()) {
                Pageable pageable = (Pageable)maybePageable.get();
                result = new PageImpl(content, pageable, aggregationResult.getTotalResults());
            }
        }
        return result;
    }

    private Object executeFtTagVals() {
        SearchOperations<String> ops = this.modulesOperations.opsForSearch(this.searchIndex);
        return ops.tagVals(this.value);
    }

    private String prepareQuery(Object[] parameters) {
        logger.debug((Object)String.format("parameters: %s", Arrays.toString(parameters)));
        ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(parameters));
        StringBuilder preparedQuery = new StringBuilder();
        boolean multipleOrParts = this.queryOrParts.size() > 1;
        logger.debug((Object)String.format("queryOrParts: %s", this.queryOrParts.size()));
        if (!this.queryOrParts.isEmpty()) {
            preparedQuery.append(this.queryOrParts.stream().map(qop -> {
                Object orPart = multipleOrParts ? "(" : "";
                orPart = (String)orPart + qop.stream().map(fieldClauses -> {
                    String fieldName = (String)fieldClauses.getFirst();
                    QueryClause queryClause = (QueryClause)((Object)((Object)((Object)fieldClauses.getSecond())));
                    int paramsCnt = queryClause.getClauseTemplate().getNumberOfArguments();
                    Object[] ps = params.subList(0, paramsCnt).toArray();
                    params.subList(0, paramsCnt).clear();
                    return queryClause.prepareQuery(fieldName, ps);
                }).collect(Collectors.joining(" "));
                orPart = (String)orPart + (multipleOrParts ? ")" : "");
                return orPart;
            }).collect(Collectors.joining(" | ")));
        } else {
            Iterator iterator = this.queryMethod.getParameters().iterator();
            int index = 0;
            if (this.value != null && !this.value.isBlank()) {
                preparedQuery.append(this.value);
            }
            while (iterator.hasNext()) {
                String key;
                Parameter p = (Parameter)iterator.next();
                Optional maybeKey = p.getName();
                if (maybeKey.isPresent()) {
                    key = (String)maybeKey.get();
                } else {
                    String string = key = this.paramNames.size() > index ? this.paramNames.get(index) : "";
                }
                if (!key.isBlank()) {
                    String v;
                    Object object = parameters[index];
                    if (object instanceof Collection) {
                        Collection c = (Collection)object;
                        v = c.stream().map(Object::toString).collect(Collectors.joining(" | "));
                    } else {
                        v = parameters[index].toString();
                    }
                    String regex = "(\\$" + key + ")(\\W+|\\*|\\+)(.*)";
                    preparedQuery = new StringBuilder(preparedQuery.toString().replaceAll(regex, v + "$2$3"));
                }
                ++index;
            }
        }
        logger.debug((Object)String.format("query: %s", preparedQuery));
        return preparedQuery.toString();
    }
}

