/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.search;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.redis.om.spring.autocomplete.Suggestion;
import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.autocomplete.AutoCompleteOptions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.search.FTSearchParams;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.RediSearchCommands;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.util.SafeEncoder;

public class SearchOperationsImpl<K>
implements SearchOperations<K> {
    private final RediSearchCommands search;
    private final RedisModulesClient modulesClient;
    private final K index;
    private final StringRedisTemplate template;

    public SearchOperationsImpl(K index, RedisModulesClient modulesClient, StringRedisTemplate template) {
        this.index = index;
        this.modulesClient = modulesClient;
        this.search = modulesClient.clientForSearch();
        this.template = template;
    }

    @Override
    public String createIndex(Schema schema, IndexOptions options) {
        return this.search.ftCreate(this.index.toString(), options, schema);
    }

    @Override
    public SearchResult search(Query q) {
        return this.search.ftSearch(SafeEncoder.encode((String)this.index.toString()), q);
    }

    @Override
    public SearchResult search(Query q, FTSearchParams params) {
        return this.search.ftSearch(this.index.toString(), q.toString(), params);
    }

    @Override
    public AggregationResult aggregate(AggregationBuilder q) {
        return this.search.ftAggregate(this.index.toString(), q);
    }

    @Override
    public String cursorDelete(long cursorId) {
        return this.search.ftCursorDel(this.index.toString(), cursorId);
    }

    @Override
    public AggregationResult cursorRead(long cursorId, int count) {
        return this.search.ftCursorRead(this.index.toString(), cursorId, count);
    }

    @Override
    public String explain(Query q) {
        return this.search.ftExplain(this.index.toString(), q);
    }

    @Override
    public Map<String, Object> getInfo() {
        return this.search.ftInfo(this.index.toString());
    }

    @Override
    public String dropIndex() {
        return this.search.ftDropIndex(this.index.toString());
    }

    @Override
    public String dropIndexAndDocuments() {
        return this.search.ftDropIndexDD(this.index.toString());
    }

    @Override
    public Long addSuggestion(String key, String suggestion) {
        return this.search.ftSugAdd(key, suggestion, 1.0);
    }

    @Override
    public Long addSuggestion(String key, String suggestion, double score) {
        return this.search.ftSugAdd(key, suggestion, score);
    }

    @Override
    public List<Suggestion> getSuggestion(String key, String prefix) {
        return this.getSuggestion(key, prefix, AutoCompleteOptions.get());
    }

    @Override
    public List<Suggestion> getSuggestion(String key, String prefix, AutoCompleteOptions options) {
        Gson gson = this.modulesClient.gsonBuilder().create();
        if (options.isWithScore()) {
            List suggestions = this.search.ftSugGetWithScores(key, prefix, options.isFuzzy(), options.getLimit());
            return suggestions.stream().map(suggestion -> {
                if (options.isWithPayload()) {
                    String[] keyParts = key.split(":");
                    String payLoadKey = String.format("sugg:payload:%s:%s", keyParts[keyParts.length - 2], keyParts[keyParts.length - 1]);
                    Object payload = this.template.opsForHash().get((Object)payLoadKey, suggestion);
                    String json = payload != null ? payload.toString() : "{}";
                    Map payloadMap = (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                    return new Suggestion(suggestion.getElement(), suggestion.getScore(), payloadMap);
                }
                return new Suggestion(suggestion.getElement(), suggestion.getScore());
            }).toList();
        }
        List suggestions = this.search.ftSugGet(key, prefix, options.isFuzzy(), options.getLimit());
        return suggestions.stream().map(suggestion -> {
            if (options.isWithPayload()) {
                String[] keyParts = key.split(":");
                String payLoadKey = String.format("sugg:payload:%s:%s", keyParts[keyParts.length - 2], keyParts[keyParts.length - 1]);
                Object payload = this.template.opsForHash().get((Object)payLoadKey, suggestion);
                String json = payload != null ? payload.toString() : "{}";
                Map payloadMap = (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                return new Suggestion((String)suggestion, payloadMap);
            }
            return new Suggestion((String)suggestion);
        }).toList();
    }

    @Override
    public Boolean deleteSuggestion(String key, String entry) {
        return this.search.ftSugDel(key, entry);
    }

    @Override
    public Long getSuggestionLength(String key) {
        return this.search.ftSugLen(key);
    }

    @Override
    public String alterIndex(SchemaField ... fields) {
        return this.search.ftAlter(this.index.toString(), fields);
    }

    @Override
    public String setConfig(String option, String value) {
        return this.search.ftConfigSet(option, value);
    }

    @Override
    public Map<String, String> getConfig(String option) {
        return this.search.ftConfigGet(option);
    }

    @Override
    public Map<String, String> getIndexConfig(String option) {
        return this.search.ftConfigGet(this.index.toString(), option);
    }

    @Override
    public String addAlias(String name) {
        return this.search.ftAliasAdd(name, this.index.toString());
    }

    @Override
    public String updateAlias(String name) {
        return this.search.ftAliasUpdate(name, this.index.toString());
    }

    @Override
    public String deleteAlias(String name) {
        return this.search.ftAliasDel(name);
    }

    @Override
    public String updateSynonym(String synonymGroupId, String ... terms) {
        return this.search.ftSynUpdate(this.index.toString(), synonymGroupId, terms);
    }

    @Override
    public Map<String, List<String>> dumpSynonym() {
        return this.search.ftSynDump(this.index.toString());
    }

    @Override
    public Set<String> tagVals(String field) {
        return this.search.ftTagVals(this.index.toString(), field);
    }
}

