/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.json;

import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.serialization.gson.ReferenceAwareGsonBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;
import redis.clients.jedis.json.JsonSetParams;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;

public class JSONOperationsImpl<K>
implements JSONOperations<K> {
    private final ReferenceAwareGsonBuilder builder;
    final RedisModulesClient client;

    public JSONOperationsImpl(RedisModulesClient client, ReferenceAwareGsonBuilder builder) {
        this.client = client;
        this.builder = builder;
    }

    @Override
    public Long del(K key, Path path) {
        return this.client.clientForJSON().jsonDel(key.toString(), path);
    }

    @Override
    @Nullable
    public String get(K key) {
        return this.client.clientForJSON().jsonGetAsPlainString(key.toString(), Path.ROOT_PATH);
    }

    @Override
    public <T> T get(K key, Class<T> clazz) {
        this.builder.processEntity(clazz);
        return (T)this.builder.gson().fromJson(this.client.clientForJSON().jsonGetAsPlainString(key.toString(), Path.ROOT_PATH), clazz);
    }

    @Override
    public <T> T get(K key, Class<T> clazz, Path path) {
        this.builder.processEntity(clazz);
        return (T)this.builder.gson().fromJson(this.client.clientForJSON().jsonGetAsPlainString(key.toString(), path), clazz);
    }

    @Override
    @SafeVarargs
    public final List<String> mget(K ... keys) {
        return this.client.clientForJSON().jsonMGet(this.getKeysAsString(keys)).stream().filter(Objects::nonNull).map(jsonArr -> jsonArr.get(0)).map(Object::toString).toList();
    }

    @Override
    @SafeVarargs
    public final <T> List<T> mget(Class<T> clazz, K ... keys) {
        this.builder.processEntity(clazz);
        return this.client.clientForJSON().jsonMGet(this.getKeysAsString(keys)).stream().filter(Objects::nonNull).map(jsonArr -> jsonArr.get(0)).map(Object::toString).map(str -> this.builder.gson().fromJson(str, clazz)).toList();
    }

    @Override
    @SafeVarargs
    public final <T> List<T> mget(Path2 path, Class<T> clazz, K ... keys) {
        this.builder.processEntity(clazz);
        return this.client.clientForJSON().jsonMGet(path, this.getKeysAsString(keys)).stream().map(Object::toString).map(str -> this.builder.gson().fromJson(str, clazz)).toList();
    }

    @Override
    public void set(K key, Object object, JsonSetParams flag) {
        this.client.clientForJSON().jsonSet(key.toString(), object, flag);
    }

    @Override
    public void set(K key, Object object) {
        this.client.clientForJSON().jsonSetWithPlainString(key.toString(), Path.ROOT_PATH, this.builder.gson().toJson(object));
    }

    @Override
    public void set(K key, Object object, Path path) {
        this.client.clientForJSON().jsonSetWithPlainString(key.toString(), path, this.builder.gson().toJson(object));
    }

    @Override
    public void set(K key, Object object, JsonSetParams params, Path path) {
        this.client.clientForJSON().jsonSet(key.toString(), path, object, params);
    }

    @Override
    public Class<?> type(K key) {
        return this.client.clientForJSON().jsonType(key.toString());
    }

    @Override
    public Class<?> type(K key, Path path) {
        return this.client.clientForJSON().jsonType(key.toString(), path);
    }

    @Override
    public Long strAppend(K key, Path path, Object object) {
        return this.client.clientForJSON().jsonStrAppend(key.toString(), path, object);
    }

    @Override
    public Long strLen(K key, Path path) {
        return this.client.clientForJSON().jsonStrLen(key.toString(), path);
    }

    @Override
    public Long arrAppend(K key, Path path, Object ... objects) {
        return this.client.clientForJSON().jsonArrAppend(key.toString(), path, objects);
    }

    @Override
    public Long arrIndex(K key, Path path, Object scalar) {
        return this.client.clientForJSON().jsonArrIndex(key.toString(), path, scalar);
    }

    @Override
    public Long arrInsert(K key, Path path, Integer index, Object ... objects) {
        return this.client.clientForJSON().jsonArrInsert(key.toString(), path, index.intValue(), objects);
    }

    @Override
    public Long arrLen(K key, Path path) {
        return this.client.clientForJSON().jsonArrLen(key.toString(), path);
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz, Path path, Integer index) {
        return (T)this.client.clientForJSON().jsonArrPop(key.toString(), clazz, path, index.intValue());
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz, Path path) {
        return (T)this.client.clientForJSON().jsonArrPop(key.toString(), clazz, path);
    }

    @Override
    public <T> T arrPop(K key, Class<T> clazz) {
        return (T)this.client.clientForJSON().jsonArrPop(key.toString(), clazz);
    }

    @Override
    public Long arrTrim(K key, Path path, Integer start, Integer stop) {
        return this.client.clientForJSON().jsonArrTrim(key.toString(), path, start.intValue(), stop.intValue());
    }

    @Override
    public void toggle(K key, Path path) {
        this.client.clientForJSON().jsonToggle(key.toString(), path);
    }

    @Override
    public Double numIncrBy(K key, Path path, Long value) {
        return this.client.clientForJSON().jsonNumIncrBy(key.toString(), path, (double)value.longValue());
    }

    @SafeVarargs
    private String[] getKeysAsString(K ... keys) {
        return (String[])Arrays.stream(keys).map(Object::toString).toArray(String[]::new);
    }
}

