/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.redis.om.spring.RediSearchIndexer;
import com.redis.om.spring.RedisOMSpringProperties;
import com.redis.om.spring.convert.RedisOMCustomConversions;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.json.JSONOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Reference;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.util.SafeEncoder;

public class RedisJSONKeyValueAdapter
extends RedisKeyValueAdapter {
    private static final Log logger = LogFactory.getLog(RedisJSONKeyValueAdapter.class);
    private final JSONOperations<?> redisJSONOperations;
    private final RedisOperations<?, ?> redisOperations;
    private final RedisMappingContext mappingContext;
    private final RedisModulesOperations<String> modulesOperations;
    private final RediSearchIndexer indexer;
    private final GsonBuilder gsonBuilder;
    private final RedisOMSpringProperties redisOMSpringProperties;

    public RedisJSONKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisModulesOperations<?> rmo, RedisMappingContext mappingContext, RediSearchIndexer keyspaceToIndexMap, GsonBuilder gsonBuilder, RedisOMSpringProperties redisOMSpringProperties) {
        super(redisOps, mappingContext, (CustomConversions)new RedisOMCustomConversions());
        this.modulesOperations = rmo;
        this.redisJSONOperations = this.modulesOperations.opsForJSON();
        this.redisOperations = redisOps;
        this.mappingContext = mappingContext;
        this.indexer = keyspaceToIndexMap;
        this.gsonBuilder = gsonBuilder;
        this.redisOMSpringProperties = redisOMSpringProperties;
    }

    public Object put(Object id, Object item, String keyspace) {
        logger.debug((Object)String.format("%s, %s, %s", id, item, keyspace));
        JSONOperations<?> ops = this.redisJSONOperations;
        String key = this.getKey(keyspace, id);
        this.processAuditAnnotations(key, item);
        Optional<Long> maybeTtl = this.getTTLForEntity(item);
        ops.set(key, item);
        this.processReferences(key, item);
        this.redisOperations.execute(connection -> {
            maybeTtl.ifPresent(aLong -> connection.keyCommands().expire(this.toBytes(key), aLong.longValue()));
            return null;
        });
        return item;
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        return this.get(this.getKey(keyspace, id), type);
    }

    @Nullable
    public <T> T get(String key, Class<T> type) {
        JSONOperations<?> ops = this.redisJSONOperations;
        return ops.get(key, type);
    }

    public <T> List<T> getAllOf(String keyspace, Class<T> type, long offset, int rows) {
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        List<Object> result = List.of();
        if (maybeSearchIndex.isPresent()) {
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(maybeSearchIndex.get());
            Query query = new Query("*");
            offset = Math.max(0L, offset);
            int limit = rows;
            if (limit <= 0) {
                limit = this.redisOMSpringProperties.getRepository().getQuery().getLimit();
            }
            query.limit(Integer.valueOf(Math.toIntExact(offset)), Integer.valueOf(limit));
            SearchResult searchResult = searchOps.search(query);
            Gson gson = this.gsonBuilder.create();
            result = searchResult.getDocuments().stream().map(d -> gson.fromJson(SafeEncoder.encode((byte[])((byte[])d.get("$"))), type)).toList();
        }
        return result;
    }

    public <T> List<String> getAllKeys(String keyspace, Class<T> type) {
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        List<String> keys = List.of();
        if (maybeSearchIndex.isPresent()) {
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(maybeSearchIndex.get());
            Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(type);
            String idField = maybeIdField.map(Field::getName).orElse("id");
            Query query = new Query("*");
            query.returnFields(new String[]{idField});
            SearchResult searchResult = searchOps.search(query);
            keys = searchResult.getDocuments().stream().map(Document::getId).toList();
        }
        return keys;
    }

    public <T> T delete(Object id, String keyspace, Class<T> type) {
        JSONOperations<?> ops = this.redisJSONOperations;
        T entity = this.get(id, keyspace, type);
        if (entity != null) {
            ops.del(this.getKey(keyspace, id), Path.ROOT_PATH);
        }
        return entity;
    }

    public void deleteAllOf(String keyspace) {
        Class<?> type = this.indexer.getEntityClassForKeyspace(keyspace);
        Optional<String> maybeSearchIndex = this.indexer.getIndexName(keyspace);
        if (maybeSearchIndex.isPresent()) {
            SearchOperations<String> searchOps = this.modulesOperations.opsForSearch(maybeSearchIndex.get());
            searchOps.dropIndexAndDocuments();
            this.indexer.createIndexFor(type);
        }
    }

    public long count(String keyspace) {
        long count = 0L;
        Optional<String> maybeIndexName = this.indexer.getIndexName(keyspace);
        if (maybeIndexName.isPresent()) {
            SearchOperations<String> search = this.modulesOperations.opsForSearch(maybeIndexName.get());
            Query query = new Query("*");
            query.limit(Integer.valueOf(0), Integer.valueOf(0));
            SearchResult result = search.search(query);
            count = result.getTotalResults();
        }
        return count;
    }

    public boolean contains(Object id, String keyspace) {
        Boolean exists = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(this.toBytes(this.getKey(keyspace, id))));
        return exists != null && exists != false;
    }

    private void processAuditAnnotations(String key, Object item) {
        boolean isNew = (Boolean)this.redisOperations.execute(connection -> connection.keyCommands().exists(this.toBytes(key)) == false);
        Class auditClass = isNew ? CreatedDate.class : LastModifiedDate.class;
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), auditClass);
        if (!fields.isEmpty()) {
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> RedisJSONKeyValueAdapter.lambda$processAuditAnnotations$5((PropertyAccessor)accessor, arg_0));
        }
    }

    private void processReferences(String key, Object item) {
        List<Field> fields = ObjectUtils.getFieldsWithAnnotation(item.getClass(), Reference.class);
        if (!fields.isEmpty()) {
            JSONOperations<?> ops = this.redisJSONOperations;
            BeanWrapper accessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
            fields.forEach(arg_0 -> this.lambda$processReferences$7((PropertyAccessor)accessor, ops, key, arg_0));
        }
    }

    protected String getKey(String keyspace, Object id) {
        return String.format("%s:%s", keyspace, id);
    }

    private Optional<Long> getTTLForEntity(Object entity) {
        Class<?> entityClassKey;
        Class<?> entityClass = entity.getClass();
        try {
            entityClassKey = ClassLoader.getSystemClassLoader().loadClass(entity.getClass().getTypeName());
        }
        catch (ClassNotFoundException e) {
            entityClassKey = entity.getClass();
        }
        KeyspaceConfiguration keyspaceConfig = this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration();
        if (keyspaceConfig.hasSettingsFor(entityClassKey)) {
            KeyspaceConfiguration.KeyspaceSettings settings = keyspaceConfig.getKeyspaceSettings(entityClassKey);
            if (StringUtils.hasText((String)settings.getTimeToLivePropertyName())) {
                try {
                    Field fld = ReflectionUtils.findField(entityClass, (String)settings.getTimeToLivePropertyName());
                    Method ttlGetter = ObjectUtils.getGetterForField(entityClass, fld);
                    Long ttlPropertyValue = ((Number)ReflectionUtils.invokeMethod((Method)ttlGetter, (Object)entity)).longValue();
                    TimeToLive ttl = fld.getAnnotation(TimeToLive.class);
                    if (!ttl.unit().equals((Object)TimeUnit.SECONDS)) {
                        return Optional.of(TimeUnit.SECONDS.convert(ttlPropertyValue, ttl.unit()));
                    }
                    return Optional.of(ttlPropertyValue);
                }
                catch (IllegalArgumentException | SecurityException e) {
                    return Optional.empty();
                }
            }
            if (settings.getTimeToLive() != null && settings.getTimeToLive() > 0L) {
                return Optional.of(settings.getTimeToLive());
            }
        }
        return Optional.empty();
    }

    private /* synthetic */ void lambda$processReferences$7(PropertyAccessor accessor, JSONOperations ops, String key, Field f) {
        Object referencedValue = accessor.getPropertyValue(f.getName());
        if (referencedValue != null) {
            if (referencedValue instanceof Collection) {
                Collection referenceValues = (Collection)referencedValue;
                ArrayList referenceKeys = new ArrayList();
                referenceValues.forEach(r -> {
                    Object id = ObjectUtils.getIdFieldForEntity(r);
                    if (id != null) {
                        String referenceKey = this.indexer.getKeyspaceForEntityClass(r.getClass()) + id;
                        referenceKeys.add(referenceKey);
                    }
                });
                ops.set(key, referenceKeys, Path.of((String)("$." + f.getName())));
            } else {
                Object id = ObjectUtils.getIdFieldForEntity(referencedValue);
                if (id != null) {
                    String referenceKey = this.indexer.getKeyspaceForEntityClass(f.getType()) + id;
                    ops.set(key, (Object)referenceKey, Path.of((String)("$." + f.getName())));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$processAuditAnnotations$5(PropertyAccessor accessor, Field f) {
        if (f.getType() == Date.class) {
            accessor.setPropertyValue(f.getName(), (Object)new Date(System.currentTimeMillis()));
        } else if (f.getType() == LocalDateTime.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDateTime.now());
        } else if (f.getType() == LocalDate.class) {
            accessor.setPropertyValue(f.getName(), (Object)LocalDate.now());
        }
    }
}

