/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.sasl;

import com.rabbitmq.stream.sasl.CredentialsProvider;
import com.rabbitmq.stream.sasl.SaslConfiguration;
import com.rabbitmq.stream.sasl.SaslMechanism;
import com.rabbitmq.stream.sasl.StreamSaslException;
import com.rabbitmq.stream.sasl.UsernamePasswordCredentialsProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class JdkSaslConfiguration
implements SaslConfiguration {
    private static final String[] DEFAULT_PREFERRED_MECHANISMS = new String[]{"PLAIN"};
    private final Supplier<String> serverNameSupplier;
    private final List<String> mechanisms;
    private final CallbackHandler callbackHandler;

    public JdkSaslConfiguration(CredentialsProvider credentialsProvider, Supplier<String> serverNameSupplier) {
        this(credentialsProvider, serverNameSupplier, DEFAULT_PREFERRED_MECHANISMS);
    }

    public JdkSaslConfiguration(CredentialsProvider credentialsProvider, Supplier<String> serverNameSupplier, String[] mechanisms) {
        this.serverNameSupplier = serverNameSupplier;
        this.callbackHandler = new UsernamePasswordCallbackHandler(credentialsProvider);
        this.mechanisms = Arrays.asList(mechanisms);
    }

    @Override
    public SaslMechanism getSaslMechanism(List<String> serverMechanisms) {
        for (String mechanism : this.mechanisms) {
            if (!serverMechanisms.contains(mechanism)) continue;
            try {
                SaslClient saslClient = Sasl.createSaslClient(new String[]{mechanism}, null, "RABBITMQ-STREAM", this.serverNameSupplier.get(), null, this.callbackHandler);
                if (saslClient == null) continue;
                return new JdkSaslMechanism(saslClient);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final UsernamePasswordCredentialsProvider credentialsProvider;

        public UsernamePasswordCallbackHandler(CredentialsProvider credentialsProvider) {
            if (!(credentialsProvider instanceof UsernamePasswordCredentialsProvider)) {
                throw new IllegalArgumentException("Only username/password credentials provider is supported, not " + CredentialsProvider.class.getSimpleName());
            }
            this.credentialsProvider = (UsernamePasswordCredentialsProvider)credentialsProvider;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.credentialsProvider.getUsername());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.credentialsProvider.getPassword().toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }

    private static class JdkSaslMechanism
    implements SaslMechanism {
        private final SaslClient client;

        public JdkSaslMechanism(SaslClient client) {
            this.client = client;
        }

        @Override
        public String getName() {
            return this.client.getMechanismName();
        }

        @Override
        public byte[] handleChallenge(byte[] challenge, CredentialsProvider credentialsProvider) {
            try {
                return this.client.evaluateChallenge(challenge);
            }
            catch (SaslException e) {
                throw new StreamSaslException(e);
            }
        }
    }
}

