/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.impl.ExecutorServiceFactory;
import com.rabbitmq.stream.impl.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExecutorServiceFactory
implements ExecutorServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorServiceFactory.class);
    private static final Comparator<Executor> EXECUTOR_COMPARATOR = Comparator.comparingInt(rec$ -> Executor.access$000((Executor)rec$));
    private final List<Executor> executors;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ThreadFactory threadFactory;
    private final int minSize;
    private final int clientPerExecutor;
    private final Supplier<Executor> executorFactory;

    DefaultExecutorServiceFactory(int minSize, int clientPerExecutor, String prefix) {
        this.minSize = minSize;
        this.clientPerExecutor = clientPerExecutor;
        this.threadFactory = new Utils.NamedThreadFactory(prefix);
        this.executorFactory = () -> this.newExecutor();
        ArrayList l = new ArrayList(this.minSize);
        IntStream.range(0, this.minSize).forEach(ignored -> l.add(this.executorFactory.get()));
        this.executors = new CopyOnWriteArrayList<Executor>(l);
    }

    static void maybeResize(List<Executor> current, int min, int clientsPerResource, Supplier<Executor> factory) {
        LOGGER.debug("Resizing {}, with min = {}, clients per resource = {}", new Object[]{current, min, clientsPerResource});
        int clientCount = 0;
        for (Executor executor : current) {
            clientCount += executor.usage();
        }
        LOGGER.debug("Total usage is {}", (Object)clientCount);
        int target = Math.max(clientCount / clientsPerResource + 1, min);
        LOGGER.debug("Target size is {}, current size is {}", (Object)target, (Object)current.size());
        if (target > current.size()) {
            LOGGER.debug("Upsizing...");
            ArrayList<Executor> l = new ArrayList<Executor>();
            for (int i = 0; i < target; ++i) {
                if (i < current.size()) {
                    l.add(current.get(i));
                    continue;
                }
                l.add(factory.get());
            }
            current.clear();
            current.addAll(l);
            LOGGER.debug("New list is {}", current);
        } else if (target < current.size()) {
            boolean hasUnusedExecutors;
            LOGGER.debug("Downsizing...");
            boolean bl = hasUnusedExecutors = current.stream().filter(ex -> ((Executor)ex).usage() == 0).count() > 0L;
            if (!hasUnusedExecutors) {
                LOGGER.debug("No downsizing, there is no unused executor");
            }
            if (hasUnusedExecutors) {
                int i;
                ArrayList<Executor> l = new ArrayList<Executor>(target);
                for (i = 0; i < current.size(); ++i) {
                    Executor executor = current.get(i);
                    if (executor.usage() == 0) {
                        executor.close();
                        continue;
                    }
                    l.add(executor);
                }
                if (l.size() < target) {
                    for (i = l.size(); i < target; ++i) {
                        l.add(factory.get());
                    }
                }
                current.clear();
                current.addAll(l);
                LOGGER.debug("New list is {}", current);
            }
        }
    }

    private Executor newExecutor() {
        return new Executor(Executors.newSingleThreadExecutor(this.threadFactory));
    }

    @Override
    public synchronized ExecutorService get() {
        if (this.closed.get()) {
            throw new IllegalStateException("Executor service factory is closed");
        }
        DefaultExecutorServiceFactory.maybeResize(this.executors, this.minSize, this.clientPerExecutor, this.executorFactory);
        LOGGER.debug("Looking least used executor in {}", this.executors);
        Executor executor = this.executors.stream().min(EXECUTOR_COMPARATOR).get();
        LOGGER.debug("Least used executor is {}", (Object)executor);
        executor.incrementUsage();
        return executor.executorService;
    }

    @Override
    public synchronized void clientClosed(ExecutorService executorService) {
        if (!this.closed.get()) {
            Executor executor = this.find(executorService);
            if (executor == null) {
                LOGGER.info("Could not find executor service wrapper");
            } else {
                executor.decrementUsage();
                DefaultExecutorServiceFactory.maybeResize(this.executors, this.minSize, this.clientPerExecutor, this.executorFactory);
            }
        }
    }

    private Executor find(ExecutorService executorService) {
        for (Executor executor : this.executors) {
            if (!executor.executorService.equals(executorService)) continue;
            return executor;
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.executors.forEach(executor -> ((Executor)executor).executorService.shutdownNow());
        }
    }

    static class Executor {
        private final ExecutorService executorService;
        private AtomicInteger usage = new AtomicInteger(0);

        Executor(ExecutorService executorService) {
            this.executorService = executorService;
        }

        Executor incrementUsage() {
            this.usage.incrementAndGet();
            return this;
        }

        Executor decrementUsage() {
            this.usage.decrementAndGet();
            return this;
        }

        Executor addUsage(int delta) {
            this.usage.addAndGet(delta);
            return this;
        }

        Executor substractUsage(int delta) {
            this.usage.addAndGet(-delta);
            return this;
        }

        private int usage() {
            return this.usage.get();
        }

        private void close() {
            this.executorService.shutdownNow();
        }

        public String toString() {
            return "Executor{usage=" + this.usage.get() + '}';
        }
    }
}

