/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.CodecFactory;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.engine.Engine;
import com.rabbitmq.qpid.protonj2.engine.EventHandler;
import com.rabbitmq.qpid.protonj2.engine.IncomingDelivery;
import com.rabbitmq.qpid.protonj2.engine.Receiver;
import com.rabbitmq.qpid.protonj2.engine.Transaction;
import com.rabbitmq.qpid.protonj2.engine.TransactionManager;
import com.rabbitmq.qpid.protonj2.engine.TransactionState;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineStateException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.ProtocolViolationException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEndpoint;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonReceiver;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonSession;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonTransaction;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import com.rabbitmq.qpid.protonj2.types.messaging.AmqpValue;
import com.rabbitmq.qpid.protonj2.types.messaging.Rejected;
import com.rabbitmq.qpid.protonj2.types.messaging.Source;
import com.rabbitmq.qpid.protonj2.types.transactions.Coordinator;
import com.rabbitmq.qpid.protonj2.types.transactions.Declare;
import com.rabbitmq.qpid.protonj2.types.transactions.Declared;
import com.rabbitmq.qpid.protonj2.types.transactions.Discharge;
import com.rabbitmq.qpid.protonj2.types.transactions.TransactionErrors;
import com.rabbitmq.qpid.protonj2.types.transport.ErrorCondition;
import java.util.HashMap;
import java.util.Map;

public final class ProtonTransactionManager
extends ProtonEndpoint<TransactionManager>
implements TransactionManager {
    private final ProtonReceiver receiverLink;
    private final Decoder payloadDecoder;
    private EventHandler<Transaction<TransactionManager>> declareEventHandler;
    private EventHandler<Transaction<TransactionManager>> dischargeEventHandler;
    private EventHandler<TransactionManager> parentEndpointClosedEventHandler;
    private Map<ProtonBuffer, ProtonManagerTransaction> transactions = new HashMap<ProtonBuffer, ProtonManagerTransaction>();

    public ProtonTransactionManager(ProtonReceiver receiverLink) {
        super(receiverLink.getEngine());
        this.payloadDecoder = CodecFactory.getDecoder();
        this.receiverLink = receiverLink;
        ((Receiver)this.receiverLink.openHandler(this::handleReceiverLinkOpened).closeHandler(this::handleReceiverLinkClosed).localOpenHandler(this::handleReceiverLinkLocallyOpened).localCloseHandler(this::handleReceiverLinkLocallyClosed).parentEndpointClosedHandler(this::handleParentEndpointClosed).engineShutdownHandler(this::handleEngineShutdown)).deliveryReadHandler(this::handleDeliveryRead).deliveryStateUpdatedHandler(this::handleDeliveryStateUpdate);
    }

    public ProtonSession getParent() {
        return this.receiverLink.getSession();
    }

    @Override
    ProtonTransactionManager self() {
        return this;
    }

    @Override
    public TransactionManager addCredit(int additional) {
        this.receiverLink.addCredit(additional);
        return this;
    }

    @Override
    public int getCredit() {
        return this.receiverLink.getCredit();
    }

    @Override
    public TransactionManager declared(Transaction<TransactionManager> transaction, Binary txnId) {
        ProtonManagerTransaction txn = (ProtonManagerTransaction)transaction;
        if (txn.parent() != this) {
            throw new IllegalArgumentException("Cannot complete declaration of a transaction from another transaction manager.");
        }
        if (txnId == null || txnId.getLength() == 0) {
            throw new IllegalArgumentException("Cannot declare a transaction without a transaction Id");
        }
        txn.setState(TransactionState.DECLARED);
        txn.setTxnId(txnId);
        this.transactions.put(txnId.asProtonBuffer(), txn);
        Declared declaration = new Declared();
        declaration.setTxnId(txnId);
        txn.getDeclare().disposition(declaration, true);
        return this;
    }

    @Override
    public TransactionManager discharged(Transaction<TransactionManager> transaction) {
        ProtonManagerTransaction txn = (ProtonManagerTransaction)transaction;
        this.transactions.remove(txn.getTxnId().asProtonBuffer());
        if (txn.parent() != this) {
            throw new IllegalArgumentException("Cannot complete discharge of a transaction from another transaction manager.");
        }
        txn.setState(TransactionState.DISCHARGED);
        txn.getDischarge().disposition(Accepted.getInstance(), true);
        return this;
    }

    @Override
    public TransactionManager declareFailed(Transaction<TransactionManager> transaction, ErrorCondition condition) {
        ProtonManagerTransaction txn = (ProtonManagerTransaction)transaction;
        if (txn.parent() != this) {
            throw new IllegalArgumentException("Cannot fail a declared transaction from another transaction manager.");
        }
        txn.setState(TransactionState.DECLARE_FAILED);
        txn.getDeclare().disposition(new Rejected().setError(condition), true);
        return this;
    }

    @Override
    public TransactionManager dischargeFailed(Transaction<TransactionManager> transaction, ErrorCondition condition) {
        ProtonManagerTransaction txn = (ProtonManagerTransaction)transaction;
        if (txn.parent() != this) {
            throw new IllegalArgumentException("Cannot fail a discharge of a transaction from another transaction manager.");
        }
        this.transactions.remove(txn.getTxnId().asProtonBuffer());
        txn.setState(TransactionState.DISCHARGE_FAILED);
        txn.getDischarge().disposition(new Rejected().setError(condition), true);
        return this;
    }

    @Override
    public TransactionManager declareHandler(EventHandler<Transaction<TransactionManager>> declaredEventHandler) {
        this.declareEventHandler = declaredEventHandler;
        return this;
    }

    @Override
    public TransactionManager dischargeHandler(EventHandler<Transaction<TransactionManager>> dischargeEventHandler) {
        this.dischargeEventHandler = dischargeEventHandler;
        return this;
    }

    @Override
    public TransactionManager parentEndpointClosedHandler(EventHandler<TransactionManager> handler) {
        this.parentEndpointClosedEventHandler = handler;
        return this;
    }

    private void fireDeclare(ProtonManagerTransaction transaction) {
        if (this.declareEventHandler != null) {
            this.declareEventHandler.handle(transaction);
        }
    }

    private void fireDischarge(ProtonManagerTransaction transaction) {
        if (this.dischargeEventHandler != null) {
            this.dischargeEventHandler.handle(transaction);
        }
    }

    private void fireParentEndpointClosed() {
        if (this.parentEndpointClosedEventHandler != null && this.isLocallyOpen()) {
            this.parentEndpointClosedEventHandler.handle(this.self());
        }
    }

    @Override
    public TransactionManager open() throws IllegalStateException, EngineStateException {
        this.receiverLink.open();
        return this;
    }

    @Override
    public TransactionManager close() throws EngineFailedException {
        this.receiverLink.close();
        return this;
    }

    @Override
    public boolean isLocallyOpen() {
        return this.receiverLink.isLocallyOpen();
    }

    @Override
    public boolean isLocallyClosed() {
        return this.receiverLink.isLocallyClosed();
    }

    @Override
    public TransactionManager setSource(Source source) throws IllegalStateException {
        this.receiverLink.setSource(source);
        return this;
    }

    @Override
    public Source getSource() {
        return this.receiverLink.getSource();
    }

    @Override
    public TransactionManager setCoordinator(Coordinator coordinator) throws IllegalStateException {
        this.receiverLink.setTarget(coordinator);
        return this;
    }

    @Override
    public Coordinator getCoordinator() {
        return (Coordinator)this.receiverLink.getTarget();
    }

    @Override
    public ErrorCondition getCondition() {
        return this.receiverLink.getCondition();
    }

    @Override
    public TransactionManager setCondition(ErrorCondition condition) {
        this.receiverLink.setCondition(condition);
        return this;
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        return this.receiverLink.getProperties();
    }

    @Override
    public TransactionManager setProperties(Map<Symbol, Object> properties) throws IllegalStateException {
        this.receiverLink.setProperties((Map)properties);
        return this;
    }

    @Override
    public TransactionManager setOfferedCapabilities(Symbol ... offeredCapabilities) throws IllegalStateException {
        this.receiverLink.setOfferedCapabilities(offeredCapabilities);
        return this;
    }

    @Override
    public Symbol[] getOfferedCapabilities() {
        return this.receiverLink.getOfferedCapabilities();
    }

    @Override
    public TransactionManager setDesiredCapabilities(Symbol ... desiredCapabilities) throws IllegalStateException {
        this.receiverLink.setDesiredCapabilities(desiredCapabilities);
        return this;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        return this.receiverLink.getDesiredCapabilities();
    }

    @Override
    public boolean isRemotelyOpen() {
        return this.receiverLink.isRemotelyOpen();
    }

    @Override
    public boolean isRemotelyClosed() {
        return this.receiverLink.isRemotelyClosed();
    }

    @Override
    public Symbol[] getRemoteOfferedCapabilities() {
        return this.receiverLink.getRemoteOfferedCapabilities();
    }

    @Override
    public Symbol[] getRemoteDesiredCapabilities() {
        return this.receiverLink.getRemoteDesiredCapabilities();
    }

    @Override
    public Map<Symbol, Object> getRemoteProperties() {
        return this.receiverLink.getRemoteProperties();
    }

    @Override
    public ErrorCondition getRemoteCondition() {
        return this.receiverLink.getRemoteCondition();
    }

    @Override
    public Source getRemoteSource() {
        return this.receiverLink.getRemoteSource();
    }

    @Override
    public Coordinator getRemoteCoordinator() {
        return (Coordinator)this.receiverLink.getRemoteTarget();
    }

    private void handleReceiverLinkLocallyOpened(Receiver receiver) {
        this.fireLocalOpen();
    }

    private void handleReceiverLinkLocallyClosed(Receiver receiver) {
        this.fireLocalClose();
    }

    private void handleReceiverLinkOpened(Receiver receiver) {
        this.fireRemoteOpen();
    }

    private void handleReceiverLinkClosed(Receiver receiver) {
        this.fireRemoteClose();
    }

    private void handleEngineShutdown(Engine engine) {
        this.fireEngineShutdown();
    }

    private void handleParentEndpointClosed(Receiver receiver) {
        this.fireParentEndpointClosed();
    }

    private void handleDeliveryRead(IncomingDelivery delivery) {
        if (delivery.isAborted()) {
            delivery.settle();
        } else if (!delivery.isPartial()) {
            ProtonBuffer payload = delivery.readAll();
            AmqpValue container = (AmqpValue)this.payloadDecoder.readObject(payload, this.payloadDecoder.getCachedDecoderState());
            if (container.getValue() instanceof Declare) {
                ProtonManagerTransaction transaction = new ProtonManagerTransaction(this);
                transaction.setDeclare(delivery);
                transaction.setState(TransactionState.DECLARING);
                this.fireDeclare(transaction);
            } else if (container.getValue() instanceof Discharge) {
                Discharge discharge = (Discharge)container.getValue();
                Binary txnId = discharge.getTxnId();
                ProtonManagerTransaction transaction = this.transactions.get(txnId.asProtonBuffer());
                if (transaction != null) {
                    transaction.setState(TransactionState.DISCHARGING);
                    transaction.setDischargeState(discharge.getFail() ? Transaction.DischargeState.ROLLBACK : Transaction.DischargeState.COMMIT);
                    this.fireDischarge(transaction.setDischarge(delivery));
                } else {
                    ErrorCondition rejection = new ErrorCondition(TransactionErrors.UNKNOWN_ID, "Transaction Manager is not tracking the given transaction ID.");
                    delivery.disposition(new Rejected(rejection), true);
                }
            } else {
                throw new ProtocolViolationException("TXN Coordinator expects Declare and Discharge Delivery payloads only");
            }
        }
    }

    private void handleDeliveryStateUpdate(IncomingDelivery delivery) {
    }

    private static final class ProtonManagerTransaction
    extends ProtonTransaction<TransactionManager> {
        private final ProtonTransactionManager manager;
        private IncomingDelivery declare;
        private IncomingDelivery discharge;

        public ProtonManagerTransaction(ProtonTransactionManager manager) {
            this.manager = manager;
        }

        @Override
        public ProtonTransactionManager parent() {
            return this.manager;
        }

        public ProtonManagerTransaction setDeclare(IncomingDelivery delivery) {
            this.declare = delivery;
            return this;
        }

        public IncomingDelivery getDeclare() {
            return this.declare;
        }

        public ProtonManagerTransaction setDischarge(IncomingDelivery delivery) {
            this.discharge = delivery;
            return this;
        }

        public IncomingDelivery getDischarge() {
            return this.discharge;
        }
    }
}

