/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.EngineHandler;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.EnginePipeline;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.IncomingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineNotWritableException;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEngine;
import com.rabbitmq.qpid.protonj2.engine.impl.ProtonEnginePipeline;
import java.util.Objects;

public class ProtonEnginePipelineProxy
implements EnginePipeline {
    private final ProtonEnginePipeline pipeline;

    ProtonEnginePipelineProxy(ProtonEnginePipeline pipeline) {
        Objects.requireNonNull(pipeline, "Must supply a real pipeline instance to wrap.");
        this.pipeline = pipeline;
    }

    @Override
    public ProtonEngine engine() {
        return this.pipeline.engine();
    }

    ProtonEnginePipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ProtonEnginePipelineProxy addFirst(String name, EngineHandler handler) {
        this.engine().checkShutdownOrFailed("Cannot add pipeline resources when Engine is shutdown or failed");
        this.pipeline.addFirst(name, handler);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy addLast(String name, EngineHandler handler) {
        this.engine().checkShutdownOrFailed("Cannot add pipeline resources when Engine is shutdown or failed");
        this.pipeline.addLast(name, handler);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy removeFirst() {
        this.pipeline.removeFirst();
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy removeLast() {
        this.pipeline.removeLast();
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy remove(String name) {
        this.pipeline.remove(name);
        return this;
    }

    @Override
    public EnginePipeline remove(EngineHandler handler) {
        this.pipeline.remove(handler);
        return this;
    }

    @Override
    public EngineHandler find(String name) {
        this.engine().checkShutdownOrFailed("Cannot access pipeline resource when Engine is shutdown or failed");
        return this.pipeline.find(name);
    }

    @Override
    public EngineHandler first() {
        this.engine().checkShutdownOrFailed("Cannot access pipeline resource when Engine is shutdown or failed");
        return this.pipeline.first();
    }

    @Override
    public EngineHandler last() {
        this.engine().checkShutdownOrFailed("Cannot access pipeline resource when Engine is shutdown or failed");
        return this.pipeline.last();
    }

    @Override
    public EngineHandlerContext firstContext() {
        this.engine().checkShutdownOrFailed("Cannot access pipeline resource when Engine is shutdown or failed");
        return this.pipeline.firstContext();
    }

    @Override
    public EngineHandlerContext lastContext() {
        this.engine().checkShutdownOrFailed("Cannot access pipeline resource when Engine is shutdown or failed");
        return this.pipeline.lastContext();
    }

    @Override
    public ProtonEnginePipelineProxy fireEngineStarting() {
        throw new IllegalAccessError("Cannot trigger starting on Engine owned Pipeline resource.");
    }

    @Override
    public ProtonEnginePipelineProxy fireEngineStateChanged() {
        throw new IllegalAccessError("Cannot trigger state changed on Engine owned Pipeline resource.");
    }

    @Override
    public ProtonEnginePipelineProxy fireFailed(EngineFailedException e) {
        throw new IllegalAccessError("Cannot trigger failed on Engine owned Pipeline resource.");
    }

    @Override
    public ProtonEnginePipelineProxy fireRead(ProtonBuffer input) {
        this.engine().checkEngineNotStarted("Cannot inject new data into an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot inject new data into an Engine that is shutdown or failed");
        this.pipeline.fireRead(input);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireRead(HeaderEnvelope header) {
        this.engine().checkEngineNotStarted("Cannot inject new data into an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot inject new data into an Engine that is shutdown or failed");
        this.pipeline.fireRead(header);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireRead(SASLEnvelope envelope) {
        this.engine().checkEngineNotStarted("Cannot inject new data into an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot inject new data into an Engine that is shutdown or failed");
        this.pipeline.fireRead(envelope);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireRead(IncomingAMQPEnvelope envelope) {
        this.engine().checkEngineNotStarted("Cannot inject new data into an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot inject new data into an Engine that is shutdown or failed");
        this.pipeline.fireRead(envelope);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireWrite(HeaderEnvelope envelope) {
        this.engine().checkEngineNotStarted("Cannot write from an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot write form an Engine that is shutdown or failed");
        if (!this.engine().isWritable()) {
            throw new EngineNotWritableException("Cannot write through Engine pipeline when Engine is not writable");
        }
        this.pipeline.fireWrite(envelope);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireWrite(OutgoingAMQPEnvelope envelope) {
        this.engine().checkEngineNotStarted("Cannot write from an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot write form an Engine that is shutdown or failed");
        if (!this.engine().isWritable()) {
            throw new EngineNotWritableException("Cannot write through Engine pipeline when Engine is not writable");
        }
        this.pipeline.fireWrite(envelope);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireWrite(SASLEnvelope envelope) {
        this.engine().checkEngineNotStarted("Cannot write from an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot write form an Engine that is shutdown or failed");
        if (!this.engine().isWritable()) {
            throw new EngineNotWritableException("Cannot write through Engine pipeline when Engine is not writable");
        }
        this.pipeline.fireWrite(envelope);
        return this;
    }

    @Override
    public ProtonEnginePipelineProxy fireWrite(ProtonBuffer buffer, Runnable ioComplete) {
        this.engine().checkEngineNotStarted("Cannot write from an unstarted Engine");
        this.engine().checkShutdownOrFailed("Cannot write form an Engine that is shutdown or failed");
        if (!this.engine().isWritable()) {
            throw new EngineNotWritableException("Cannot write through Engine pipeline when Engine is not writable");
        }
        this.pipeline.fireWrite(buffer, ioComplete);
        return this;
    }
}

