/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.engine.Engine;
import com.rabbitmq.qpid.protonj2.engine.EngineHandler;
import com.rabbitmq.qpid.protonj2.engine.EngineHandlerContext;
import com.rabbitmq.qpid.protonj2.engine.HeaderEnvelope;
import com.rabbitmq.qpid.protonj2.engine.IncomingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import com.rabbitmq.qpid.protonj2.engine.SASLEnvelope;
import com.rabbitmq.qpid.protonj2.engine.exceptions.EngineFailedException;

public class ProtonEngineHandlerContext
implements EngineHandlerContext {
    ProtonEngineHandlerContext previous;
    ProtonEngineHandlerContext next;
    public static final int HANDLER_READS = 2;
    public static final int HANDLER_WRITES = 4;
    public static final int HANDLER_ALL_EVENTS = 6;
    private final String name;
    private final Engine engine;
    private final EngineHandler handler;
    private int interestMask = 6;

    public ProtonEngineHandlerContext(String name, Engine engine, EngineHandler handler) {
        this.name = name;
        this.engine = engine;
        this.handler = handler;
    }

    @Override
    public EngineHandler handler() {
        return this.handler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Engine engine() {
        return this.engine;
    }

    public int interestMask() {
        return this.interestMask;
    }

    public ProtonEngineHandlerContext interestMask(int mask) {
        this.interestMask = mask;
        return this;
    }

    @Override
    public void fireEngineStarting() {
        this.next.invokeEngineStarting();
    }

    @Override
    public void fireEngineStateChanged() {
        this.next.invokeEngineStateChanged();
    }

    @Override
    public void fireFailed(EngineFailedException failure) {
        this.next.invokeEngineFailed(failure);
    }

    @Override
    public void fireRead(ProtonBuffer buffer) {
        this.findNextReadHandler().invokeHandlerRead(buffer);
    }

    @Override
    public void fireRead(HeaderEnvelope header) {
        this.findNextReadHandler().invokeHandlerRead(header);
    }

    @Override
    public void fireRead(SASLEnvelope envelope) {
        this.findNextReadHandler().invokeHandlerRead(envelope);
    }

    @Override
    public void fireRead(IncomingAMQPEnvelope envelope) {
        this.findNextReadHandler().invokeHandlerRead(envelope);
    }

    @Override
    public void fireWrite(OutgoingAMQPEnvelope envelope) {
        this.findNextWriteHandler().invokeHandlerWrite(envelope);
    }

    @Override
    public void fireWrite(SASLEnvelope envelope) {
        this.findNextWriteHandler().invokeHandlerWrite(envelope);
    }

    @Override
    public void fireWrite(HeaderEnvelope envelope) {
        this.findNextWriteHandler().invokeHandlerWrite(envelope);
    }

    @Override
    public void fireWrite(ProtonBuffer buffer, Runnable ioComplete) {
        this.findNextWriteHandler().invokeHandlerWrite(buffer, ioComplete);
    }

    void invokeEngineStarting() {
        this.handler.engineStarting(this);
    }

    void invokeEngineStateChanged() {
        this.handler.handleEngineStateChanged(this);
    }

    void invokeEngineFailed(EngineFailedException failure) {
        this.handler.engineFailed(this, failure);
    }

    void invokeHandlerRead(IncomingAMQPEnvelope envelope) {
        this.handler.handleRead((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerRead(SASLEnvelope envelope) {
        this.handler.handleRead((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerRead(HeaderEnvelope envelope) {
        this.handler.handleRead((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerRead(ProtonBuffer buffer) {
        this.handler.handleRead((EngineHandlerContext)this, buffer);
    }

    void invokeHandlerWrite(OutgoingAMQPEnvelope envelope) {
        this.handler.handleWrite((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerWrite(SASLEnvelope envelope) {
        this.handler.handleWrite((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerWrite(HeaderEnvelope envelope) {
        this.handler.handleWrite((EngineHandlerContext)this, envelope);
    }

    void invokeHandlerWrite(ProtonBuffer buffer, Runnable ioComplete) {
        this.next.handler().handleWrite(this.next, buffer, ioComplete);
    }

    private ProtonEngineHandlerContext findNextReadHandler() {
        ProtonEngineHandlerContext ctx = this;
        while (ProtonEngineHandlerContext.skipContext(ctx = ctx.previous, 2)) {
        }
        return ctx;
    }

    private ProtonEngineHandlerContext findNextWriteHandler() {
        ProtonEngineHandlerContext ctx = this;
        while (ProtonEngineHandlerContext.skipContext(ctx = ctx.next, 4)) {
        }
        return ctx;
    }

    private static boolean skipContext(ProtonEngineHandlerContext ctx, int interestMask) {
        return (ctx.interestMask() & interestMask) == 0;
    }
}

