/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transactions;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transactions.Discharge;
import java.io.InputStream;

public final class DischargeTypeDecoder
extends AbstractDescribedListTypeDecoder<Discharge> {
    private static final int MIN_DISCHARGE_LIST_ENTRIES = 1;
    private static final int MAX_DISCHARGE_LIST_ENTRIES = 2;

    @Override
    public Class<Discharge> getTypeClass() {
        return Discharge.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Discharge.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Discharge.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Discharge readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDischarge(buffer, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Discharge[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Discharge[] result = new Discharge[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDischarge(buffer, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Discharge readDischarge(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Discharge discharge = new Discharge();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 1) {
            throw new DecodeException("Not enough entries in Discharge list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in Discharge list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    discharge.setTxnId(state.getDecoder().readBinary(buffer, state));
                    continue block4;
                }
                case 1: {
                    discharge.setFail(state.getDecoder().readBoolean(buffer, state, false));
                }
            }
        }
        return discharge;
    }

    @Override
    public Discharge readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDischarge(stream, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Discharge[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Discharge[] result = new Discharge[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDischarge(stream, state, (ListTypeDecoder)DischargeTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Discharge readDischarge(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Discharge discharge = new Discharge();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 1) {
            throw new DecodeException("Not enough entries in Discharge list encoding: " + count);
        }
        if (count > 2) {
            throw new DecodeException("To many entries in Discharge list encoding: " + count);
        }
        block4: for (int index = 0; index < count; ++index) {
            switch (index) {
                case 0: {
                    discharge.setTxnId(state.getDecoder().readBinary(stream, state));
                    continue block4;
                }
                case 1: {
                    discharge.setFail(state.getDecoder().readBoolean(stream, state, false));
                }
            }
        }
        return discharge;
    }
}

