/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import java.io.InputStream;

public final class FloatTypeDecoder
extends AbstractPrimitiveTypeDecoder<Float> {
    @Override
    public boolean isJavaPrimitive() {
        return true;
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    @Override
    public int getTypeCode() {
        return 114;
    }

    @Override
    public Float readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public Float readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return Float.valueOf(ProtonStreamUtils.readFloat(stream));
    }

    public float readPrimitiveValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readFloat();
    }

    public float readPrimitiveValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readFloat(stream);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(4);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 4L);
    }

    @Override
    public int readSize(ProtonBuffer buffer, DecoderState state) {
        return 4;
    }

    @Override
    public int readSize(InputStream stream, StreamDecoderState state) {
        return 4;
    }
}

