/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.messaging;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeEOFException;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.List32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.List8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Accepted;
import java.io.InputStream;

public final class AcceptedTypeDecoder
extends AbstractDescribedListTypeDecoder<Accepted> {
    private static final ListTypeDecoder SMALL_LIST_TYPE_DECODER = new List8TypeDecoder();
    private static final ListTypeDecoder LARGE_LIST_TYPE_DECODER = new List32TypeDecoder();

    @Override
    public Class<Accepted> getTypeClass() {
        return Accepted.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Accepted.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Accepted.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Accepted readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode;
        try {
            encodingCode = buffer.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodeEOFException(e);
        }
        switch (encodingCode) {
            case 69: {
                break;
            }
            case -64: {
                SMALL_LIST_TYPE_DECODER.skipValue(buffer, state);
                break;
            }
            case -48: {
                LARGE_LIST_TYPE_DECODER.skipValue(buffer, state);
                break;
            }
            default: {
                throw new DecodeException("Expected list encoding but got decoder for type code: " + encodingCode);
            }
        }
        return Accepted.getInstance();
    }

    public Accepted[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        AcceptedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        Accepted[] result = new Accepted[count];
        for (int i = 0; i < count; ++i) {
            decoder.skipValue(buffer, state);
            result[i] = Accepted.getInstance();
        }
        return result;
    }

    @Override
    public Accepted readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        AcceptedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
        return Accepted.getInstance();
    }

    public Accepted[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        AcceptedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        Accepted[] result = new Accepted[count];
        for (int i = 0; i < count; ++i) {
            decoder.skipValue(stream, state);
            result[i] = Accepted.getInstance();
        }
        return result;
    }
}

