/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.transport.netty4;

import com.rabbitmq.qpid.protonj2.client.TransportOptions;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KQueueSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KQueueSupport.class);
    public static final String NAME = "KQUEUE";

    public static boolean isAvailable(TransportOptions transportOptions) {
        return transportOptions.allowNativeIO() && KQueueSupport.isAvailable();
    }

    public static boolean isAvailable() {
        try {
            return KQueue.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for KQueue support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        KQueueSupport.ensureAvailability();
        return new MultiThreadIoEventLoopGroup(nThreads, ioThreadFactory, KQueueIoHandler.newFactory());
    }

    public static Class<? extends Channel> getChannelClass() {
        KQueueSupport.ensureAvailability();
        return KQueueSocketChannel.class;
    }

    public static void ensureAvailability() {
        if (!KQueueSupport.isAvailable()) {
            throw new UnsupportedOperationException("Netty KQueue support is not enabled because the Netty library indicates it is not present or disabled");
        }
    }
}

