/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.buffer;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAccessors;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferIterator;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferUtils;
import com.rabbitmq.qpid.protonj2.resource.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public interface ProtonBuffer
extends ProtonBufferAccessors,
Resource<ProtonBuffer>,
Comparable<ProtonBuffer> {
    @Override
    public void close();

    public boolean isDirect();

    default public Object unwrap() {
        return this;
    }

    public ProtonBuffer convertToReadOnly();

    public boolean isReadOnly();

    @Override
    public boolean isClosed();

    default public int getReadableBytes() {
        return this.getWriteOffset() - this.getReadOffset();
    }

    public int getReadOffset();

    public ProtonBuffer setReadOffset(int var1);

    default public ProtonBuffer advanceReadOffset(int length) {
        ProtonBufferUtils.checkIsNotNegative(length, "Read offset advance requires positive values");
        this.setReadOffset(this.getReadOffset() + length);
        return this;
    }

    default public boolean isReadable() {
        return this.getReadOffset() < this.getWriteOffset();
    }

    default public int getWritableBytes() {
        return this.capacity() - this.getWriteOffset();
    }

    public int getWriteOffset();

    public ProtonBuffer setWriteOffset(int var1);

    default public ProtonBuffer advanceWriteOffset(int length) {
        ProtonBufferUtils.checkIsNotNegative(length, "Write offset advance requires positive values");
        this.setWriteOffset(this.getWriteOffset() + length);
        return this;
    }

    default public boolean isWritable() {
        return this.getWriteOffset() < this.capacity();
    }

    public ProtonBuffer fill(byte var1);

    public int capacity();

    public int implicitGrowthLimit();

    public ProtonBuffer implicitGrowthLimit(int var1);

    default public ProtonBuffer ensureWritable(int amount) throws IndexOutOfBoundsException, IllegalArgumentException {
        return this.ensureWritable(amount, this.capacity(), true);
    }

    public ProtonBuffer ensureWritable(int var1, int var2, boolean var3) throws IndexOutOfBoundsException, IllegalArgumentException;

    default public ProtonBuffer copy() {
        return this.copy(this.getReadOffset(), this.getReadableBytes());
    }

    default public ProtonBuffer copy(int index, int length) {
        return this.copy(index, length, false);
    }

    default public ProtonBuffer copy(boolean readOnly) {
        return this.copy(this.getReadOffset(), this.getReadableBytes(), readOnly);
    }

    public ProtonBuffer copy(int var1, int var2, boolean var3) throws IllegalArgumentException;

    default public ProtonBuffer clear() {
        this.setReadOffset(0);
        if (!this.isReadOnly()) {
            this.setWriteOffset(0);
        }
        return this;
    }

    public ProtonBuffer compact();

    default public ProtonBuffer readSplit(int length) {
        return this.split(this.getReadOffset() + length);
    }

    default public ProtonBuffer writeSplit(int length) {
        return this.split(this.getWriteOffset() + length);
    }

    default public ProtonBuffer split() {
        return this.split(this.getWriteOffset());
    }

    public ProtonBuffer split(int var1);

    default public String toString(Charset charset) {
        return ProtonBufferUtils.toString(this, charset);
    }

    @Override
    default public int compareTo(ProtonBuffer buffer) {
        return ProtonBufferUtils.compare(this, buffer);
    }

    default public ProtonBuffer writeCharSequence(CharSequence source, Charset charset) {
        ProtonBufferUtils.writeCharSequence(source, this, charset);
        return this;
    }

    default public CharSequence readCharSequence(int length, Charset charset) {
        return ProtonBufferUtils.readCharSequence(this, length, charset);
    }

    public void copyInto(int var1, byte[] var2, int var3, int var4);

    public void copyInto(int var1, ByteBuffer var2, int var3, int var4);

    public void copyInto(int var1, ProtonBuffer var2, int var3, int var4);

    default public ProtonBuffer writeBytes(ProtonBuffer source) {
        int size = source.getReadableBytes();
        if (this.getWritableBytes() < size && this.getWriteOffset() + size <= this.implicitGrowthLimit()) {
            this.ensureWritable(size, 1, false);
        }
        source.copyInto(source.getReadOffset(), this, this.getWriteOffset(), size);
        source.advanceReadOffset(size);
        this.advanceWriteOffset(size);
        return this;
    }

    default public ProtonBuffer writeBytes(byte[] source) {
        return this.writeBytes(source, 0, source.length);
    }

    default public ProtonBuffer writeBytes(byte[] source, int offset, int length) {
        int writeOffset = this.getWriteOffset();
        if (this.getWritableBytes() < length && this.getWriteOffset() + length <= this.implicitGrowthLimit()) {
            this.ensureWritable(length, 1, false);
        }
        this.advanceWriteOffset(length);
        for (int i = 0; i < length; ++i) {
            this.setByte(writeOffset + i, source[offset + i]);
        }
        return this;
    }

    default public ProtonBuffer writeBytes(ByteBuffer source) {
        if (source.hasArray()) {
            this.writeBytes(source.array(), source.arrayOffset() + source.position(), source.remaining());
            source.position(source.limit());
        } else {
            int writeOffset = this.getWriteOffset();
            int length = source.remaining();
            if (this.getWritableBytes() < length && this.getWriteOffset() + length <= this.implicitGrowthLimit()) {
                this.ensureWritable(length, 1, false);
            }
            this.advanceWriteOffset(source.remaining());
            while (length >= 8) {
                this.setLong(writeOffset, source.getLong());
                length -= 8;
                writeOffset += 8;
            }
            while (length >= 4) {
                this.setInt(writeOffset, source.getInt());
                length -= 4;
                writeOffset += 4;
            }
            while (length > 0) {
                this.setByte(writeOffset, source.get());
                --length;
                ++writeOffset;
            }
        }
        return this;
    }

    default public ProtonBuffer readBytes(ByteBuffer destination) {
        int byteCount = destination.remaining();
        this.copyInto(this.getReadOffset(), destination, destination.position(), byteCount);
        this.advanceReadOffset(byteCount);
        destination.position(destination.limit());
        return this;
    }

    default public ProtonBuffer readBytes(byte[] destination, int offset, int length) {
        this.copyInto(this.getReadOffset(), destination, offset, length);
        this.advanceReadOffset(length);
        return this;
    }

    public int transferTo(WritableByteChannel var1, int var2) throws IOException;

    public int transferFrom(ReadableByteChannel var1, int var2) throws IOException;

    public int transferFrom(FileChannel var1, long var2, int var4) throws IOException;

    public boolean isComposite();

    public int componentCount();

    public int readableComponentCount();

    public int writableComponentCount();

    public ProtonBufferComponentAccessor componentAccessor();

    default public ProtonBufferIterator bufferIterator() {
        return this.bufferIterator(this.getReadOffset(), this.getReadableBytes());
    }

    public ProtonBufferIterator bufferIterator(int var1, int var2);

    default public ProtonBufferIterator bufferReverseIterator() {
        return this.bufferReverseIterator(Math.max(0, this.getWriteOffset() - 1), this.getReadableBytes());
    }

    public ProtonBufferIterator bufferReverseIterator(int var1, int var2);

    default public int indexOf(byte needle) {
        return this.indexOf(needle, this.getReadOffset(), this.getReadableBytes());
    }

    public int indexOf(byte var1, int var2, int var3);
}

