/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.CredentialsProvider;
import com.rabbitmq.client.amqp.OAuth2Settings;
import com.rabbitmq.client.amqp.UsernamePasswordCredentialsProvider;
import com.rabbitmq.client.amqp.impl.AmqpEnvironment;
import com.rabbitmq.client.amqp.impl.DefaultConnectionSettings;
import com.rabbitmq.client.amqp.impl.UsernamePasswordCredentialsManager;
import com.rabbitmq.client.amqp.oauth2.CredentialsManager;
import com.rabbitmq.client.amqp.oauth2.GsonTokenParser;
import com.rabbitmq.client.amqp.oauth2.HttpTokenRequester;
import com.rabbitmq.client.amqp.oauth2.TokenCredentialsManager;
import java.net.http.HttpClient;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

final class CredentialsManagerFactory {
    private volatile CredentialsManager globalOAuth2CredentialsManager;
    private final Lock oauth2CredentialsLock = new ReentrantLock();
    private final AmqpEnvironment environment;

    CredentialsManagerFactory(AmqpEnvironment environment) {
        this.environment = environment;
    }

    CredentialsManager credentials(DefaultConnectionSettings<?> settings) {
        CredentialsManager credentialsManager;
        CredentialsProvider provider = settings.credentialsProvider();
        if (((DefaultConnectionSettings.DefaultOAuth2Settings)settings.oauth2()).enabled()) {
            credentialsManager = ((DefaultConnectionSettings.DefaultOAuth2Settings)settings.oauth2()).shared() ? this.globalOAuth2Credentials(settings) : this.createOAuth2Credentials(settings);
        } else if (provider instanceof UsernamePasswordCredentialsProvider) {
            UsernamePasswordCredentialsProvider credentialsProvider = (UsernamePasswordCredentialsProvider)provider;
            credentialsManager = new UsernamePasswordCredentialsManager(credentialsProvider);
        } else {
            credentialsManager = CredentialsManager.NO_OP;
        }
        return credentialsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialsManager globalOAuth2Credentials(DefaultConnectionSettings<?> connectionSettings) {
        CredentialsManager result = this.globalOAuth2CredentialsManager;
        if (result != null) {
            return result;
        }
        this.oauth2CredentialsLock.lock();
        try {
            if (this.globalOAuth2CredentialsManager == null) {
                this.globalOAuth2CredentialsManager = this.createOAuth2Credentials(connectionSettings);
            }
            CredentialsManager credentialsManager = this.globalOAuth2CredentialsManager;
            return credentialsManager;
        }
        finally {
            this.oauth2CredentialsLock.unlock();
        }
    }

    private CredentialsManager createOAuth2Credentials(DefaultConnectionSettings<?> connectionSettings) {
        OAuth2Settings settings = connectionSettings.oauth2();
        Consumer<HttpClient.Builder> clientBuilderConsumer = ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).tlsEnabled() ? arg_0 -> CredentialsManagerFactory.lambda$createOAuth2Credentials$0((DefaultConnectionSettings.DefaultOAuth2Settings)settings, arg_0) : ignored -> {};
        HttpTokenRequester tokenRequester = new HttpTokenRequester(((DefaultConnectionSettings.DefaultOAuth2Settings)settings).tokenEndpointUri(), ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).clientId(), ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).clientSecret(), ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).grantType(), ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).parameters(), clientBuilderConsumer, null, new GsonTokenParser());
        return new TokenCredentialsManager(tokenRequester, this.environment.scheduledExecutorService(), ((DefaultConnectionSettings.DefaultOAuth2Settings)settings).refreshDelayStrategy());
    }

    private static /* synthetic */ void lambda$createOAuth2Credentials$0(DefaultConnectionSettings.DefaultOAuth2Settings settings, HttpClient.Builder b) {
        b.sslContext(((DefaultConnectionSettings.DefaultOAuthTlsSettings)settings.tls()).sslContext());
    }
}

