/*
 * Decompiled with CFR 0.152.
 */
package com.pili;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.pili.API;
import com.pili.PiliException;
import com.qiniu.Credentials;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Stream {
    public static final String ORIGIN = "ORIGIN";
    private String mStreamJsonStr;
    private Credentials mCredentials;
    private String id;
    private String createdAt;
    private String updatedAt;
    private String title;
    private String hub;
    private String publishKey;
    private String publishSecurity;
    private boolean disabled;
    private String[] profiles;
    private String publishRtmpHost;
    private String liveRtmpHost;
    private String liveHdlHost;
    private String liveHlsHost;
    private String playbackHlshost;

    public Stream(JsonObject jsonObj) {
        this.id = jsonObj.get("id").getAsString();
        this.hub = jsonObj.get("hub").getAsString();
        this.createdAt = jsonObj.get("createdAt").getAsString();
        this.updatedAt = jsonObj.get("updatedAt").getAsString();
        this.title = jsonObj.get("title").getAsString();
        this.publishKey = jsonObj.get("publishKey").getAsString();
        this.publishSecurity = jsonObj.get("publishSecurity").getAsString();
        this.disabled = jsonObj.get("disabled").getAsBoolean();
        Type arrType = new TypeToken<String[]>(){}.getType();
        this.profiles = (String[])new Gson().fromJson(jsonObj.get("profiles"), arrType);
        JsonObject hosts = jsonObj.getAsJsonObject("hosts");
        JsonObject publish = hosts.getAsJsonObject("publish");
        JsonObject live = hosts.getAsJsonObject("live");
        JsonObject playback = hosts.getAsJsonObject("playback");
        if (publish != null) {
            this.publishRtmpHost = publish.get("rtmp").getAsString();
        }
        if (live != null) {
            this.liveHdlHost = live.get("hdl").getAsString();
            this.liveHlsHost = live.get("hls").getAsString();
            this.liveRtmpHost = live.get("rtmp").getAsString();
        }
        if (playback != null) {
            this.playbackHlshost = playback.get("hls").getAsString();
        }
        this.mStreamJsonStr = jsonObj.toString();
    }

    public Stream(JsonObject jsonObject, Credentials credentials) {
        this(jsonObject);
        this.mCredentials = credentials;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public String getPublishRtmpHost() {
        return this.publishRtmpHost;
    }

    public String getLiveRtmpHost() {
        return this.liveRtmpHost;
    }

    public String getPlaybackHlshost() {
        return this.playbackHlshost;
    }

    public String getLiveHdlHost() {
        return this.liveHdlHost;
    }

    public String getLiveHlsHost() {
        return this.liveHlsHost;
    }

    public String getStreamId() {
        return this.id;
    }

    public String getHubName() {
        return this.hub;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPublishKey() {
        return this.publishKey;
    }

    public String getPublishSecurity() {
        return this.publishSecurity;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Stream update(String publishKey, String publishSecrity, boolean disabled) throws PiliException {
        return API.updateStream(this.mCredentials, this.id, publishKey, publishSecrity, disabled);
    }

    public SegmentList segments() throws PiliException {
        return API.getStreamSegments(this.mCredentials, this.id, 0L, 0L, 0);
    }

    public SegmentList segments(long start, long end) throws PiliException {
        return API.getStreamSegments(this.mCredentials, this.id, start, end, 0);
    }

    public SegmentList segments(long start, long end, int limit) throws PiliException {
        return API.getStreamSegments(this.mCredentials, this.id, start, end, limit);
    }

    public Status status() throws PiliException {
        return API.getStreamStatus(this.mCredentials, this.id);
    }

    public String rtmpPublishUrl() throws PiliException {
        return API.publishUrl(this, 0L);
    }

    public Map<String, String> rtmpLiveUrls() {
        return API.rtmpLiveUrl(this);
    }

    public Map<String, String> hlsLiveUrls() {
        return API.hlsLiveUrl(this);
    }

    public Map<String, String> hlsPlaybackUrls(long start, long end) throws PiliException {
        return API.hlsPlaybackUrl(this.mCredentials, this, start, end);
    }

    public Map<String, String> httpFlvLiveUrls() {
        return API.httpFlvLiveUrl(this);
    }

    public String delete() throws PiliException {
        return API.deleteStream(this.mCredentials, this.id);
    }

    public String toJsonString() {
        return this.mStreamJsonStr;
    }

    public SaveAsResponse saveAs(String fileName, String format, long startTime, long endTime, String notifyUrl, String pipeline) throws PiliException {
        return API.saveAs(this.mCredentials, this.id, fileName, format, startTime, endTime, notifyUrl, pipeline);
    }

    public SaveAsResponse saveAs(String fileName, String format, long startTime, long endTime) throws PiliException {
        return this.saveAs(fileName, format, startTime, endTime, null, null);
    }

    public SaveAsResponse saveAs(String fileName, long startTime, long endTime) throws PiliException {
        return this.saveAs(fileName, null, startTime, endTime, null, null);
    }

    public SnapshotResponse snapshot(String name, String format) throws PiliException {
        return API.snapshot(this.mCredentials, this.id, name, format, 0L, null);
    }

    public SnapshotResponse snapshot(String name, String format, long time, String notifyUrl) throws PiliException {
        return API.snapshot(this.mCredentials, this.id, name, format, time, notifyUrl);
    }

    public Stream enable() throws PiliException {
        return API.updateStream(this.mCredentials, this.id, null, null, false);
    }

    public Stream disable() throws PiliException {
        return API.updateStream(this.mCredentials, this.id, null, null, true);
    }

    public static class StreamList {
        private String marker;
        private boolean end;
        private List<Stream> itemList;

        public StreamList(JsonObject jsonObj, Credentials auth) {
            this.marker = jsonObj.get("marker").getAsString();
            this.end = jsonObj.get("end").getAsBoolean();
            this.itemList = new ArrayList<Stream>();
            try {
                JsonArray respArray = jsonObj.getAsJsonArray("items");
                Iterator it = respArray.iterator();
                while (it.hasNext()) {
                    JsonObject json = ((JsonElement)it.next()).getAsJsonObject();
                    this.itemList.add(new Stream(json, auth));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public String getMarker() {
            return this.marker;
        }

        public boolean isEnd() {
            return this.end;
        }

        public List<Stream> getStreams() {
            return this.itemList;
        }
    }

    public static class Status {
        private String addr;
        private String status;
        private float bytesPerSecond;
        private FramesPerSecond framesPerSecond;
        private String startFrom;
        private String mJsonString;

        public Status(JsonObject jsonObj) {
            this.addr = jsonObj.get("addr").getAsString();
            this.status = jsonObj.get("status").getAsString();
            try {
                this.startFrom = jsonObj.get("startFrom").getAsString();
                this.bytesPerSecond = jsonObj.get("bytesPerSecond").getAsFloat();
                JsonObject framesPerSecondJsonObj = jsonObj.getAsJsonObject("framesPerSecond");
                float audio = framesPerSecondJsonObj.get("audio").getAsFloat();
                float video = framesPerSecondJsonObj.get("video").getAsFloat();
                float data = framesPerSecondJsonObj.get("data").getAsFloat();
                this.framesPerSecond = new FramesPerSecond(audio, video, data);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            this.mJsonString = jsonObj.toString();
        }

        public String getAddr() {
            return this.addr;
        }

        public String getStatus() {
            return this.status;
        }

        public float getBytesPerSecond() {
            return this.bytesPerSecond;
        }

        public FramesPerSecond getFramesPerSecond() {
            return this.framesPerSecond;
        }

        public String getStartFrom() {
            return this.startFrom;
        }

        public String toString() {
            return this.mJsonString;
        }
    }

    public static class SegmentList {
        private long start;
        private long end;
        private int duration;
        private List<Segment> segmentList;

        public SegmentList(JsonObject jsonObj) {
            this.start = jsonObj.get("start").getAsLong();
            this.end = jsonObj.get("end").getAsLong();
            this.duration = jsonObj.get("duration").getAsInt();
            JsonArray respArray = jsonObj.getAsJsonArray("segments");
            Iterator it = respArray.iterator();
            this.segmentList = new ArrayList<Segment>();
            while (it.hasNext()) {
                JsonObject json = ((JsonElement)it.next()).getAsJsonObject();
                this.segmentList.add(new Segment(json.get("start").getAsLong(), json.get("end").getAsLong()));
            }
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public int getDuration() {
            return this.duration;
        }

        public List<Segment> getSegmentList() {
            return this.segmentList;
        }
    }

    public static class FramesPerSecond {
        private float audio;
        private float video;
        private float data;

        public FramesPerSecond(float audio, float video, float data) {
            this.audio = audio;
            this.video = video;
            this.data = data;
        }

        public float getAudio() {
            return this.audio;
        }

        public float getVideo() {
            return this.video;
        }

        public float getData() {
            return this.data;
        }
    }

    public static class SnapshotResponse {
        private String targetUrl;
        private String persistentId;
        private String mJsonString;

        public SnapshotResponse(JsonObject jsonObj) {
            this.targetUrl = jsonObj.get("targetUrl").getAsString();
            this.persistentId = jsonObj.get("persistentId") == null ? null : jsonObj.get("persistentId").getAsString();
            this.mJsonString = jsonObj.toString();
        }

        public String getTargetUrl() {
            return this.targetUrl;
        }

        public String getPersistentId() {
            return this.persistentId;
        }

        public String toString() {
            return this.mJsonString;
        }
    }

    public static class SaveAsResponse {
        private String url;
        private String targetUrl;
        private String persistentId;
        private String mJsonString;

        public SaveAsResponse(JsonObject jsonObj) {
            this.url = jsonObj.get("url").getAsString();
            try {
                this.targetUrl = jsonObj.get("targetUrl").getAsString();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.persistentId = jsonObj.get("persistentId").getAsString();
            this.mJsonString = jsonObj.toString();
        }

        public String getUrl() {
            return this.url;
        }

        public String getTargetUrl() {
            return this.targetUrl;
        }

        public String getPersistentId() {
            return this.persistentId;
        }

        public String toString() {
            return this.mJsonString;
        }
    }

    public static class Segment {
        private long start;
        private long end;

        public Segment(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

