/*
 * Decompiled with CFR 0.152.
 */
package com.pili;

import com.pili.API;
import com.pili.PiliException;
import com.pili.Stream;
import com.qiniu.Credentials;

public final class Hub {
    private Credentials mCredentials;
    private String mHubName;

    public Hub(Credentials credentials, String hubName) {
        if (hubName == null) {
            throw new IllegalArgumentException("FATAL EXCEPTION: hubName is null!");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("FATAL EXCEPTION: credentials is null!");
        }
        this.mCredentials = credentials;
        this.mHubName = hubName;
    }

    public Stream createStream() throws PiliException {
        return API.createStream(this.mCredentials, this.mHubName, null, null, null);
    }

    public Stream createStream(String title, String publishKey, String publishSecurity) throws PiliException {
        return API.createStream(this.mCredentials, this.mHubName, title, publishKey, publishSecurity);
    }

    public Stream getStream(String streamId) throws PiliException {
        return API.getStream(this.mCredentials, streamId);
    }

    public Stream.StreamList listStreams() throws PiliException {
        return API.listStreams(this.mCredentials, this.mHubName, null, null, 0L, null);
    }

    public Stream.StreamList listStreams(String marker, long limit) throws PiliException {
        return API.listStreams(this.mCredentials, this.mHubName, null, marker, limit, null);
    }

    public Stream.StreamList listStreams(String marker, long limit, String titlePrefix) throws PiliException {
        return API.listStreams(this.mCredentials, this.mHubName, null, marker, limit, titlePrefix);
    }

    public Stream.StreamList listStreams(String status, String marker, long limit, String titlePrefix) throws PiliException {
        return API.listStreams(this.mCredentials, this.mHubName, status, marker, limit, titlePrefix);
    }
}

