/*
 * Decompiled with CFR 0.152.
 */
package com.pili;

import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pili.Configuration;
import com.pili.PiliException;
import com.pili.Stream;
import com.pili.common.Utils;
import com.qiniu.Credentials;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;

public final class API {
    private static final String API_BASE_URL = String.format("%s://%s/%s", Configuration.getInstance().USE_HTTPS ? "https" : "http", Configuration.getInstance().API_HOST, Configuration.getInstance().API_VERSION);
    private static final OkHttpClient mOkHttpClient = new OkHttpClient();

    private API() {
    }

    public static Stream createStream(Credentials credentials, String hubName, String title, String publishKey, String publishSecurity) throws PiliException {
        String urlStr = API_BASE_URL + "/streams";
        JsonObject json = new JsonObject();
        json.addProperty("hub", hubName);
        if (Utils.isArgNotEmpty(title)) {
            if (title.length() < 5 || title.length() > 200) {
                throw new PiliException("The length of title should be at least:5,or at most:200");
            }
            json.addProperty("title", title);
        }
        if (Utils.isArgNotEmpty(publishKey)) {
            json.addProperty("publishKey", publishKey);
        }
        if (Utils.isArgNotEmpty(publishSecurity)) {
            json.addProperty("publishSecurity", publishSecurity);
        }
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String contentType = "application/json";
            byte[] body = json.toString().getBytes("UTF-8");
            String macToken = credentials.signRequest(url, "POST", body, contentType);
            RequestBody rBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])body);
            Request request = new Request.Builder().url(url).post(rBody).header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).addHeader("Content-Type", contentType).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream(jsonObj, credentials);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream getStream(Credentials credentials, String streamId) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        String urlStr = String.format("%s/streams/%s", API_BASE_URL, streamId);
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String macToken = credentials.signRequest(url, "GET", null, null);
            Request request = new Request.Builder().url(url).get().header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream(jsonObj, credentials);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream.StreamList listStreams(Credentials credentials, String hubName, String status, String startMarker, long limitCount, String titlePrefix) throws PiliException {
        try {
            hubName = URLEncoder.encode(hubName, "UTF-8");
            if (Utils.isArgNotEmpty(status)) {
                if ("connected".equals(status)) {
                    status = URLEncoder.encode(status, "UTF-8");
                } else {
                    throw new PiliException("status can only be connected");
                }
            }
            if (Utils.isArgNotEmpty(startMarker)) {
                startMarker = URLEncoder.encode(startMarker, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        String urlStr = String.format("%s/streams?hub=%s", API_BASE_URL, hubName);
        if (Utils.isArgNotEmpty(status)) {
            urlStr = urlStr + "&status=" + status;
        }
        if (Utils.isArgNotEmpty(startMarker)) {
            urlStr = urlStr + "&marker=" + startMarker;
        }
        if (limitCount > 0L) {
            urlStr = urlStr + "&limit=" + limitCount;
        }
        if (Utils.isArgNotEmpty(titlePrefix)) {
            urlStr = urlStr + "&title=" + titlePrefix;
        }
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String macToken = credentials.signRequest(url, "GET", null, null);
            Request request = new Request.Builder().url(url).get().header("User-Agent", Utils.getUserAgent()).header("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream.StreamList(jsonObj, credentials);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream.Status getStreamStatus(Credentials credentials, String streamId) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        String urlStr = String.format("%s/streams/%s/status", API_BASE_URL, streamId);
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String macToken = credentials.signRequest(url, "GET", null, null);
            Request request = new Request.Builder().url(url).get().header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream.Status(jsonObj);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream updateStream(Credentials credentials, String streamId, String publishKey, String publishSecurity, boolean disabled) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        JsonObject json = new JsonObject();
        if (Utils.isArgNotEmpty(publishKey)) {
            json.addProperty("publishKey", publishKey);
        }
        if (Utils.isArgNotEmpty(publishSecurity)) {
            json.addProperty("publishSecurity", publishSecurity);
        }
        json.addProperty("disabled", Boolean.valueOf(disabled));
        String urlStr = String.format("%s/streams/%s", API_BASE_URL, streamId);
        Response response = null;
        try {
            byte[] body = json.toString().getBytes("UTF-8");
            URL url = new URL(urlStr);
            String contentType = "application/json";
            String macToken = credentials.signRequest(url, "POST", body, contentType);
            MediaType type = MediaType.parse((String)contentType);
            RequestBody rBody = RequestBody.create((MediaType)type, (byte[])body);
            Request request = new Request.Builder().post(rBody).url(url).header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream(jsonObj, credentials);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static String deleteStream(Credentials credentials, String streamId) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        String urlStr = String.format("%s/streams/%s", API_BASE_URL, streamId);
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String macToken = credentials.signRequest(url, "DELETE", null, null);
            Request request = new Request.Builder().url(url).delete().header("User-Agent", Utils.getUserAgent()).header("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        if (response.isSuccessful()) {
            return new String(response.message());
        }
        throw new PiliException(response);
    }

    public static Stream.SaveAsResponse saveAs(Credentials credentials, String streamId, String fileName, String format, long start, long end, String notifyUrl, String pipeline) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        if (!Utils.isArgNotEmpty(fileName)) {
            throw new PiliException("Illegal file name !");
        }
        if (start <= 0L || end <= 0L || start > end) {
            throw new PiliException("Illegal startTime or endTime!");
        }
        String urlStr = String.format("%s/streams/%s/saveas", API_BASE_URL, streamId);
        Response response = null;
        JsonObject json = new JsonObject();
        json.addProperty("name", fileName);
        if (Utils.isArgNotEmpty(notifyUrl)) {
            json.addProperty("notifyUrl", notifyUrl);
        }
        if (Utils.isArgNotEmpty(pipeline)) {
            json.addProperty("pipeline", pipeline);
        }
        json.addProperty("start", (Number)start);
        json.addProperty("end", (Number)end);
        if (Utils.isArgNotEmpty(format)) {
            json.addProperty("format", format);
        }
        try {
            URL url = new URL(urlStr);
            String contentType = "application/json";
            byte[] body = json.toString().getBytes("UTF-8");
            String macToken = credentials.signRequest(url, "POST", body, contentType);
            MediaType type = MediaType.parse((String)contentType);
            RequestBody rBody = RequestBody.create((MediaType)type, (byte[])body);
            Request request = new Request.Builder().post(rBody).url(url).header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                return new Stream.SaveAsResponse(jsonObj);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream.SnapshotResponse snapshot(Credentials credentials, String streamId, String fileName, String format, long time, String notifyUrl) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        if (!Utils.isArgNotEmpty(fileName)) {
            throw new PiliException("Illegal file name !");
        }
        if (!Utils.isArgNotEmpty(format)) {
            throw new PiliException("Illegal format !");
        }
        String urlStr = String.format("%s/streams/%s/snapshot", API_BASE_URL, streamId);
        Response response = null;
        JsonObject json = new JsonObject();
        json.addProperty("name", fileName);
        json.addProperty("format", format);
        if (time > 0L) {
            json.addProperty("time", (Number)time);
        }
        if (Utils.isArgNotEmpty(notifyUrl)) {
            json.addProperty("notifyUrl", notifyUrl);
        }
        try {
            URL url = new URL(urlStr);
            String contentType = "application/json";
            byte[] body = json.toString().getBytes("UTF-8");
            String macToken = credentials.signRequest(url, "POST", body, contentType);
            MediaType type = MediaType.parse((String)contentType);
            RequestBody rBody = RequestBody.create((MediaType)type, (byte[])body);
            Request request = new Request.Builder().post(rBody).url(url).header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                System.out.println(jsonObj.toString());
                return new Stream.SnapshotResponse(jsonObj);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static Stream.SegmentList getStreamSegments(Credentials credentials, String streamId, long startTime, long endTime, int limitCount) throws PiliException {
        if (streamId == null) {
            throw new PiliException("FATAL EXCEPTION: streamId is null!");
        }
        String urlStr = String.format("%s/streams/%s/segments", API_BASE_URL, streamId);
        if (startTime > 0L && endTime > 0L && startTime < endTime) {
            urlStr = urlStr + "?start=" + startTime + "&end=" + endTime;
        }
        if (limitCount > 0) {
            urlStr = urlStr + "&limit=" + limitCount;
        }
        Response response = null;
        try {
            URL url = new URL(urlStr);
            String macToken = credentials.signRequest(url, "GET", null, null);
            Request request = new Request.Builder().url(url).get().header("User-Agent", Utils.getUserAgent()).addHeader("Authorization", macToken).build();
            response = mOkHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        if (response.isSuccessful()) {
            JsonParser parser = new JsonParser();
            try {
                JsonObject jsonObj = parser.parse(response.body().string()).getAsJsonObject();
                if (jsonObj.get("segments") instanceof JsonNull) {
                    throw new PiliException("Segments is null");
                }
                return new Stream.SegmentList(jsonObj);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PiliException(e);
            }
        }
        throw new PiliException(response);
    }

    public static String publishUrl(Stream stream, long nonce) throws PiliException {
        String defaultScheme = "rtmp";
        if ("dynamic".equals(stream.getPublishSecurity())) {
            return API.generateDynamicUrl(stream, nonce, "rtmp");
        }
        if ("static".equals(stream.getPublishSecurity())) {
            return API.generateStaticUrl(stream, "rtmp");
        }
        return API.generateDynamicUrl(stream, nonce, "rtmp");
    }

    public static Map<String, String> rtmpLiveUrl(Stream stream) {
        String defaultScheme = "rtmp";
        String url = String.format("%s://%s/%s/%s", "rtmp", stream.getLiveRtmpHost(), stream.getHubName(), stream.getTitle());
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("ORIGIN", url);
        String[] profiles = stream.getProfiles();
        if (profiles != null) {
            for (String p : profiles) {
                dictionary.put(p, url + '@' + p);
            }
        }
        return dictionary;
    }

    public static Map<String, String> hlsLiveUrl(Stream stream) {
        String defaultScheme = "http";
        String url = String.format("%s://%s/%s/%s", "http", stream.getLiveHlsHost(), stream.getHubName(), stream.getTitle());
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("ORIGIN", url + ".m3u8");
        String[] profiles = stream.getProfiles();
        if (profiles != null) {
            for (String p : profiles) {
                dictionary.put(p, url + '@' + p + ".m3u8");
            }
        }
        return dictionary;
    }

    public static Map<String, String> hlsPlaybackUrl(Credentials credentials, Stream stream, long startTime, long endTime) throws PiliException {
        Stream.SaveAsResponse response = API.saveAs(credentials, stream.getStreamId(), "" + System.currentTimeMillis() / 1000L, null, startTime, endTime, null, null);
        HashMap<String, String> dictionary = new HashMap<String, String>();
        if (response != null) {
            dictionary.put("ORIGIN", response.getUrl());
        }
        return dictionary;
    }

    public static Map<String, String> httpFlvLiveUrl(Stream stream) {
        String defaultScheme = "http";
        String url = String.format("%s://%s/%s/%s", "http", stream.getLiveHdlHost(), stream.getHubName(), stream.getTitle());
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("ORIGIN", url + ".flv");
        String[] profiles = stream.getProfiles();
        if (profiles != null) {
            for (String p : profiles) {
                dictionary.put(p, url + '@' + p + ".flv");
            }
        }
        return dictionary;
    }

    private static String generateStaticUrl(Stream stream, String scheme) {
        return String.format("%s://%s/%s/%s?key=%s", scheme, stream.getPublishRtmpHost(), stream.getHubName(), stream.getTitle(), stream.getPublishKey());
    }

    private static String generateDynamicUrl(Stream stream, long nonce, String scheme) throws PiliException {
        if (nonce <= 0L) {
            nonce = System.currentTimeMillis() / 1000L;
        }
        String baseUri = "/" + stream.getHubName() + "/" + stream.getTitle() + "?nonce=" + nonce;
        String publishToken = null;
        try {
            publishToken = Credentials.sign(stream.getPublishKey(), baseUri);
        }
        catch (SignatureException e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
        return String.format("%s://%s%s&token=%s", scheme, stream.getPublishRtmpHost(), baseUri, publishToken);
    }
}

