/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.models.db;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qaprosoft.zafira.models.db.AbstractEntity;
import com.qaprosoft.zafira.models.db.Group;
import com.qaprosoft.zafira.models.db.Permission;
import com.qaprosoft.zafira.models.db.UserPreference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
extends AbstractEntity
implements Comparable<User> {
    private static final long serialVersionUID = 2720141152633805371L;
    private String username;
    private String password;
    private String email;
    private String firstName;
    private String lastName;
    private String photoURL;
    private List<Group> groups = new ArrayList<Group>();
    private List<UserPreference> preferences = new ArrayList<UserPreference>();
    private Date lastLogin;

    public User() {
    }

    public User(long id) {
        super.setId(id);
    }

    public User(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getPhotoURL() {
        return this.photoURL;
    }

    public void setPhotoURL(String photoURL) {
        this.photoURL = photoURL;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public void setRoles(List<Group.Role> roles) {
    }

    public List<Group.Role> getRoles() {
        HashSet<Group.Role> roles = new HashSet<Group.Role>();
        for (Group group : this.groups) {
            roles.add(group.getRole());
        }
        return new ArrayList<Group.Role>(roles);
    }

    public Set<Permission> getPermissions() {
        return this.groups.stream().flatMap(group -> group.getPermissions().stream()).collect(Collectors.toSet());
    }

    public List<Group> getGrantedGroups() {
        this.groups.forEach(group -> {
            group.setUsers(null);
            group.setId(null);
            group.setCreatedAt(null);
            group.setModifiedAt(null);
            group.getPermissions().forEach(permission -> permission.setId(null));
        });
        return this.groups;
    }

    public List<UserPreference> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(List<UserPreference> preferences) {
        this.preferences = preferences;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Override
    public int compareTo(User user) {
        return this.username.compareTo(user.getUsername());
    }
}

